//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊbV}l[Wwb_
 * @author Junpee
 */

#ifndef TRANSLATION_MESH_MANAGER_H_
#define TRANSLATION_MESH_MANAGER_H_

#include <Core/Container/HashMap.h>
#include <Core/Container/ArrayList.h>
#include <Translator/Mesh/TranslationRigidMesh.h>
#include <Translator/Mesh/TranslationCharacterMesh.h>

namespace LampForMaya{

class TranslationMesh;

//------------------------------------------------------------------------------
/**
 * ϊbV}l[W
 */
class TranslationMeshManager{
public:
	/**
	 * RXgN^
	 */
	TranslationMeshManager();

	/**
	 * fXgN^
	 */
	virtual ~TranslationMeshManager();

	/**
	 * Lampւ̕ϊ
	 * @param scene ϊV[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene) const;

	/**
	 * NA
	 * @return 폜IuWFNg
	 */
	virtual int clear();

	/**
	 * ̃bV̍쐬
	 *
	 * łɓbṼbV݂ƃG[ɂȂ܂B
	 * 󕶎𖼑OɎw肷ƃG[ɂȂ܂B
	 * @param meshName bV
	 * @return 쐬ꂽbV
	 */
	TranslationRigidMesh* createRigidMesh(const String& meshName);

	/**
	 * LN^bV̍쐬
	 *
	 * łɓbṼbV݂ƃG[ɂȂ܂B
	 * 󕶎𖼑OɎw肷ƃG[ɂȂ܂B
	 * @param meshName bV
	 * @return 쐬ꂽbV
	 */
	TranslationCharacterMesh* createCharacterMesh(const String& meshName);

	/**
	 * bV̎擾
	 * @return bV
	 */
	virtual int getCount() const{ return array_.getCount(); }

	/**
	 * bV̎擾
	 * @param index bṼCfNX
	 * @return bV
	 */
	virtual TranslationMesh* get(int index) const{ return array_.get(index); }

	/**
	 * bV̌
	 * @param name 郁bV
	 * @return bV
	 */
	virtual TranslationMesh* search(String name) const{
		return database_.get(name);
	}

protected:

private:
	// Rs[RXgN^̉B
	TranslationMeshManager(const TranslationMeshManager& copy);

	// Rs[̉B
	void operator =(const TranslationMeshManager& copy);

	// bVf[^x[X
	Lamp::HashMap<String, TranslationMesh*> database_;
	// bVz
	ArrayList<TranslationMesh*> array_;
};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_MESH_MANAGER_H_
//------------------------------------------------------------------------------
