//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊbV}l[W
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Mesh/TranslationMeshManager.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationMeshManager::TranslationMeshManager() :
	database_(256, 0.75f), array_(256){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationMeshManager::~TranslationMeshManager(){
	Assert(database_.getCount() == 0);
	Assert(array_.getCount() == 0);
	if(getCount() != 0){ clear(); }
}
//------------------------------------------------------------------------------
// Lampւ̕ϊ
bool TranslationMeshManager::convertToLamp(Scene* scene) const{
	for(int i = 0; i < getCount(); i++){
		if(!get(i)->convertToLamp(scene)){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// NA
int TranslationMeshManager::clear(){
	int result = getCount();
	// vf̍폜
	for(int i = 0; i < result; i++){ delete array_.get(i); }
	array_.clear();
	database_.clear();
	return result;
}
//------------------------------------------------------------------------------
// ̃bV̍쐬
TranslationRigidMesh* TranslationMeshManager::createRigidMesh(
	const String& meshName){
	// Ȍd`FbN
	TranslationMesh* exist = search(meshName);
	if(exist != NULL){
		MayaErrorOut(String("TranslationMeshManager::createRigidMesh() "
			"OdĂ܂ ") + meshName);
		return NULL;
	}
	// bV
	TranslationRigidMesh* mesh = new TranslationRigidMesh(meshName);
	database_.put(meshName, mesh);
	array_.add(mesh);
	return mesh;
}
//------------------------------------------------------------------------------
// LN^bV̍쐬
TranslationCharacterMesh* TranslationMeshManager::createCharacterMesh(
	const String& meshName){
	// Ȍd`FbN
	TranslationMesh* exist = search(meshName);
	if(exist != NULL){
		MayaErrorOut(String("TranslationMeshManager::createCharacterMesh() "
			"OdĂ܂ ") + meshName);
		return NULL;
	}
	// bV
	TranslationCharacterMesh* mesh = new TranslationCharacterMesh(meshName);
	database_.put(meshName, mesh);
	array_.add(mesh);
	return mesh;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
