//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊbVwb_
 * @author Junpee
 */

#ifndef TRANSLATION_MESH_H_
#define TRANSLATION_MESH_H_

namespace Lamp{
	class Scene;
}

namespace LampForMaya{

class TranslationRigidMesh;
class TranslationCharacterMesh;

//------------------------------------------------------------------------------
/**
 * ϊbV
 */
class TranslationMesh{
friend class TranslationMeshManager;
public:
	/**
	 * fXgN^
	 */
	virtual ~TranslationMesh();

	/**
	 * Lampւ̕ϊ
	 * @param scene V[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene) = 0;

	/**
	 * O̎擾
	 * @return O
	 */
	virtual String getName() const{ return name_; }

	/**
	 * s{bg̃RpC
	 * @param pivot s{bgʒu
	 */
	virtual void compilePivot(const Vector3& pivot){}

	/**
	 * _`FbN
	 * @return true
	 */
	virtual bool logicalCheck() = 0;

	//--------------------------------------------------------------------------
	/**
	 * }eA̐ݒ
	 * @param materialName }eA
	 */
	virtual void setMaterialName(const String& materialName){
		materialName_ = materialName;
	}

	/**
	 * ʒu̒ǉ
	 * @param position ǉʒu
	 */
	virtual void addPosition(const Vector3& position){
		positions_.add(position);
	}

	/**
	 * @̒ǉ
	 * @param normal ǉ@
	 */
	virtual void addNormal(const Vector3& normal){ normals_.add(normal); }

	/**
	 * F̒ǉ
	 * @param color ǉF
	 */
	virtual void addColor(const Color4f& color){ colors_.add(color); }

	/**
	 * UV̒ǉ
	 * @param uv ǉUV
	 */
	virtual void addUV(const TexCoord2& uv){ uvs_.add(uv); }

	/**
	 * UVZbg̐ݒ
	 * @param uvSetCount UVZbg
	 */
	virtual void setUVSetCount(int uvSetCount){ uvSetCount_ = uvSetCount; }

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * ̃bVǂ
	 * @return ̃bVȂtrue
	 */
	virtual bool isRigidMesh() const{ return false; }

	/**
	 * ̃bVւ̃LXg
	 * @return ̃bVB^ႦNULLԂB
	 */
	virtual TranslationRigidMesh* castRigidMesh() const{
		if(isRigidMesh()){
			return (TranslationRigidMesh*)this;
		}
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * LN^bVǂ
	 * @return LN^bVȂtrue
	 */
	virtual bool isCharacterMesh() const{ return false; }

	/**
	 * LN^bVւ̃LXg
	 * @return LN^bVB^ႦNULLԂB
	 */
	virtual TranslationCharacterMesh* castCharacterMesh() const{
		if(isCharacterMesh()){
			return (TranslationCharacterMesh*)this;
		}
		return NULL;
	}

	//--------------------------------------------------------------------------

protected:
	/**
	 * RXgN^
	 * @param initializeName 閼O
	 */
	TranslationMesh(const String& initializeName);

	/**
	 * __`FbN
	 * @return Ȃture
	 */
	virtual bool vertexLogicalCheck();

	/// O
	String name_;
	/// }eA
	String materialName_;
	/// ʒuz
	ArrayList<Vector3> positions_;
	/// @z
	ArrayList<Vector3> normals_;
	/// Fz
	ArrayList<Color4f> colors_;
	/// UVz
	ArrayList<TexCoord2> uvs_;
	/// UVZbg
	int uvSetCount_;

private:
	// Rs[RXgN^̉B
	TranslationMesh(const TranslationMesh& copy);

	// Rs[̉B
	void operator =(const TranslationMesh& copy);


};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_MESH_H_
//------------------------------------------------------------------------------
