//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊbV
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Mesh/TranslationMesh.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationMesh::TranslationMesh(const String& initializeName) :
	name_(initializeName), uvSetCount_(0){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationMesh::~TranslationMesh(){
}
//------------------------------------------------------------------------------
// __`FbN
bool TranslationMesh::vertexLogicalCheck(){
	String errorString;
	// ʒu
	int vertexCount = positions_.getCount();
	if((vertexCount % 3) != 0){
		errorString.format("TranslationMesh::vertexLogicalCheck() "
			"%s̒_(%d)3Ŋ؂܂",
			name_.getBytes(), vertexCount);
		MayaErrorOut(errorString);
		return false;
	}

	// @
	int normalCount = normals_.getCount();
	if(normalCount != vertexCount){
		errorString.format("TranslationMesh::vertexLogicalCheck() "
			"%s̒_(%d)Ɩ@(%d)Ⴂ܂",
			name_.getBytes(), vertexCount, normalCount);
		MayaErrorOut(errorString);
		return false;
	}

	// @̒`FbN
	for(int i = 0; i < normalCount; i++){
		Vector3 normal = normals_.get(i);
		float length = normal.getLength();
		if(Math::abs(length - 1.f) > Math::epsilon){
			Vector3 position = positions_.get(i);
			errorString.format("TranslationMesh::vertexLogicalCheck() "
				"%s̖@̒(%f)1ł܂ position%s",
				name_.getBytes(), length, position.toString().getBytes());
			MayaErrorOut(errorString);
			return false;
		}
	}

	// J[
	int colorCount = colors_.getCount();
	if((colorCount != vertexCount) && (colorCount != 0)){
		errorString.format("TranslationMesh::vertexLogicalCheck() "
			"%s̒_(%d)ƒ_J[(%d)Ⴂ܂",
			name_.getBytes(), vertexCount, colorCount);
		MayaErrorOut(errorString);
		return false;
	}

	// UV
	int uvCount = uvs_.getCount();
	if((uvCount != (vertexCount * uvSetCount_)) && (uvCount != 0)){
		errorString.format("TranslationMesh::vertexLogicalCheck() "
			"%s̒_(%d * %d)UV(%d)Ⴂ܂",
			name_.getBytes(), vertexCount, uvSetCount_, uvCount);
		MayaErrorOut(errorString);
		return false;
	}
	return true;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
