//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊLN^bVwb_
 * @author Junpee
 */

#ifndef TRANSLATION_CHARACTER_MESH_H_
#define TRANSLATION_CHARACTER_MESH_H_

#include <Translator/Mesh/TranslationMesh.h>
#include <Core/Container/ArrayList.h>

namespace Lamp{
	class Mesh;
}

namespace LampForMaya{

//------------------------------------------------------------------------------
/**
 * ϊLN^bV
 */
class TranslationCharacterMesh : public TranslationMesh{
friend class TranslationMeshManager;
public:
	/**
	 * fXgN^
	 */
	virtual ~TranslationCharacterMesh();

	/**
	 * LN^bVǂ
	 * @return LN^bVȂtrue
	 */
	virtual bool isCharacterMesh() const{ return true; }

	//--------------------------------------------------------------------------
	/**
	 * _`FbN
	 * @return true
	 */
	virtual bool logicalCheck();

	//--------------------------------------------------------------------------
	/**
	 * Lampւ̕ϊ
	 * @param scene V[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene);

	//--------------------------------------------------------------------------
	/**
	 * CfbNX̒ǉ
	 * @param index ǉCfbNX
	 */
	virtual void addIndex(int index){ indices_.add(index); }

	/**
	 * EFCg̐ݒ
	 * @param boneCount {[
	 * @param weights EFCg
	 * @param weightCounts e_̃EFCg
	 */
	virtual bool setWeights(
		int boneCount, float* weights, int* weightCounts);

protected:
	/**
	 * RXgN^
	 * @param initializeName 閼O
	 */
	TranslationCharacterMesh(const String& initializeName);

	/**
	 * LN^bVւ̕ϊ
	 * @param scene V[
	 * @return bV
	 */
	virtual Mesh* convertCharacterMesh(Scene* scene);

private:
	// Rs[RXgN^̉B
	TranslationCharacterMesh(const TranslationCharacterMesh& copy);

	// Rs[̉B
	void operator =(const TranslationCharacterMesh& copy);

	// CfbNXz
	ArrayList<int> indices_;
	// őEFCg
	int maxWeightCount_;
	// EFCg
	float* weights_;
	// {[CfbNX
	int* boneIndices_;
};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_CHARACTER_MESH_H_
//------------------------------------------------------------------------------
