//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊLN^bV
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Mesh/TranslationCharacterMesh.h"
#include "Graphics/Scene/Scene.h"
#include "Graphics/Mesh/MeshManager.h"
#include "Graphics/MeshData/MeshDataManager.h"
#include "Graphics/Material/MaterialManager.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationCharacterMesh::TranslationCharacterMesh(
	const String& initializeName) :
	TranslationMesh(initializeName), maxWeightCount_(0),
	weights_(NULL), boneIndices_(NULL){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationCharacterMesh::~TranslationCharacterMesh(){
	SafeArrayDelete(weights_);
	SafeArrayDelete(boneIndices_);
}
//------------------------------------------------------------------------------
// EFCg̐ݒ
bool TranslationCharacterMesh::setWeights(
	int boneCount, float* weights, int* weightCounts){
	// bVɂőEFCg̎Zo
	maxWeightCount_ = 0;
	for(int i = 0; i < indices_.getCount(); i++){
		int index = indices_[i];
		if(weightCounts[indices_[i]] > maxWeightCount_){
			maxWeightCount_ = weightCounts[indices_[i]];
		}
	}
	if(maxWeightCount_ == 0){
		MayaErrorOut("TranslationCharacterMesh::setWeights() "
			"Weight܂B");
	}

	// EFCg̐ݒ
	weights_ = new float[indices_.getCount() * maxWeightCount_];
	boneIndices_ = new int[indices_.getCount() * maxWeightCount_];
	// fXeBl[V_[v
	for(int i = 0; i < indices_.getCount(); i++){
		int destinationOffset = i * maxWeightCount_;
		int index = indices_.get(i);
		int sourceOffset = index * boneCount;
		int writeCount = 0;
		// \[X{[[v
		for(int j = 0; j < boneCount; j++){
			if(weights[sourceOffset + j] != 0.f){
				weights_[destinationOffset + writeCount] =
					weights[sourceOffset + j];
				boneIndices_[destinationOffset + writeCount] = j;
				writeCount++;
			}
		}
		// 󂫃f[^𖄂߂
		for(int j = writeCount; j < maxWeightCount_; j++){
			weights_[destinationOffset + j] = 0.f;
			boneIndices_[destinationOffset + j] = 0;
		}
	}
	return true;
}
//------------------------------------------------------------------------------
// _`FbN
bool TranslationCharacterMesh::logicalCheck(){
	if(!vertexLogicalCheck()){ return false; }
	String errorString;
	int vertexCount = positions_.getCount();
	// CfbNX
	if(indices_.getCount() != vertexCount){
		errorString.format("TranslationCharacterMesh::logicalCheck() "
			"%s̒_(%d)ƃCfbNX(%d)Ⴂ܂",
			name_.getBytes(), vertexCount, indices_.getCount());
		MayaErrorOut(errorString);
		return false;
	}
	return true;
}
//------------------------------------------------------------------------------
// Lampւ̕ϊ
bool TranslationCharacterMesh::convertToLamp(Scene* scene){
	// LN^bVւ̕ϊ
	Mesh* mesh = convertCharacterMesh(scene);
	// }eAƂ̃N
	MaterialManager* materialManager = scene->getMaterialManager();
	Material* material = materialManager->search(materialName_);
	if(material == NULL){
		MayaErrorOut(String("TranslationCharacterMesh::convertToLamp() ") +
			name_ + "ɐڑĂ}eA" + materialName_ +
			"܂ ");
		return false;
	}
	mesh->setMaterial(material);
	return true;
}
//------------------------------------------------------------------------------
// LN^bVւ̕ϊ
Mesh* TranslationCharacterMesh::convertCharacterMesh(Scene* scene){
	MeshManager* meshManager = scene->getMeshManager();
	CharacterMesh* mesh = meshManager->createCharacterMesh(name_);
	// bVf[^
	MeshDataManager* meshDataManager = scene->getMeshDataManager();
	String meshDataName(name_);
	meshDataName.append("d");
	MeshData* meshData = meshDataManager->createMeshData(meshDataName);
	mesh->setMeshData(meshData);
	// ݒ
	mesh->setPrimitiveType(Mesh::triangleList);
	int vertexCount = positions_.getCount();
	mesh->setVertexCount(vertexCount);
	mesh->enableNormal(true);
	for(int i = 0; i < vertexCount; i++){
		mesh->setPosition(i, positions_[i]);
		mesh->setNormal(i, normals_[i]);
	}
	if(colors_.getCount() != 0){
		mesh->enableColor(true);
		for(int i = 0; i < vertexCount; i++){
			Color4c color(colors_[i]);
			mesh->setColor(i, color);
		}
	}
	if(uvs_.getCount() != 0){
		mesh->setTexCoordSetCount(uvSetCount_);
		for(int i = 0; i < uvSetCount_; i++){
			mesh->setTexCoordType(i, TexCoord::type2);
		}
		int uvIndex = 0;
		int polygonCount = vertexCount / 3;
		for(int i = 0; i < polygonCount; i++){
			int vertexOffset = i * 3;
			for(int j = 0; j < uvSetCount_; j++){
				mesh->setTexCoord2(vertexOffset + 0, j, uvs_[uvIndex]);
				uvIndex++;
				mesh->setTexCoord2(vertexOffset + 1, j, uvs_[uvIndex]);
				uvIndex++;
				mesh->setTexCoord2(vertexOffset + 2, j, uvs_[uvIndex]);
				uvIndex++;
			}
		}
	}
	mesh->setBonesPerVertex(maxWeightCount_);
	int boneCount = maxWeightCount_;
	int weightCount = mesh->getWeightsPerVertex();
	for(int i = 0; i < vertexCount; i++){
		int offset = i * maxWeightCount_;
		for(int j = 0; j < boneCount; j++){
			mesh->setBoneIndex(i, j, boneIndices_[offset + j]);
		}
		// ԍŌWeight͎̂Ă
		for(int j = 0; j < weightCount; j++){
			mesh->setWeight(i, j, weights_[offset + j]);
		}
	}
	return mesh;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
