//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊ}eA}l[Wwb_
 * @author Junpee
 */

#ifndef TRANSLATION_MATERIAL_MANAGER_H_
#define TRANSLATION_MATERIAL_MANAGER_H_

#include <Core/Container/HashMap.h>
#include <Core/Container/ArrayList.h>

namespace Lamp{
	class Scene;
}

namespace LampForMaya{

class TranslationMaterial;

//------------------------------------------------------------------------------
/**
 * ϊ}eA}l[W
 */
class TranslationMaterialManager{
public:
	/**
	 * RXgN^
	 */
	TranslationMaterialManager();

	/**
	 * fXgN^
	 */
	virtual ~TranslationMaterialManager();

	/**
	 * }eA̎W
	 * @return true
	 */
	virtual bool collectMaterials();

	/**
	 * Lampւ̕ϊ
	 * @param scene ϊV[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene) const;

	/**
	 * NA
	 * @return 폜IuWFNg
	 */
	virtual int clear();

	/**
	 * }eA̎擾
	 * @return }eA
	 */
	virtual int getCount() const{ return array_.getCount(); }

	/**
	 * }eA̎擾
	 * @param index }eÃCfNX
	 * @return }eA
	 */
	virtual TranslationMaterial* get(int index) const{
		return array_.get(index);
	}

	/**
	 * }eǍ
	 * @param name }eA
	 * @return }eA
	 */
	virtual TranslationMaterial* search(String name) const{
		return database_.get(name);
	}

protected:
	/**
	 * }eẢ
	 * @param materialObject }eAIuWFNg
	 * @return true
	 */
	virtual bool analysisMaterial(const MObject& materialObject);

private:
	// Rs[RXgN^̉B
	TranslationMaterialManager(const TranslationMaterialManager& copy);

	// Rs[̉B
	void operator =(const TranslationMaterialManager& copy);

	// }eAf[^x[X
	Lamp::HashMap<String, TranslationMaterial*> database_;
	// }eAz
	ArrayList<TranslationMaterial*> array_;

};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_MATERIAL_MANAGER_H_
//------------------------------------------------------------------------------
