//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊ}eA}l[W
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Material/TranslationMaterialManager.h"
#include "Translator/Material/TranslationBasicMaterial.h"
#include "Material/Basic/LampBasicMaterial.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationMaterialManager::TranslationMaterialManager() :
	database_(256, 0.75f), array_(256){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationMaterialManager::~TranslationMaterialManager(){
	Assert(database_.getCount() == 0);
	Assert(array_.getCount() == 0);
	if(getCount() != 0){ clear(); }
}
//------------------------------------------------------------------------------
// }eA̎W
bool TranslationMaterialManager::collectMaterials(){
	MStatus result;
	// n[hEFA}eAm[h̃Ce[^̓oOĂۂ
//	MItDependencyNodes dependencyNodeIterator(MFn::kHwMaterialNode, &result);
	MItDependencyNodes dependencyNodeIterator(MFn::kInvalid, &result);
	MayaStatusCheck(result);
	for( ; !dependencyNodeIterator.isDone(); dependencyNodeIterator.next()){
		MObject materialObject = dependencyNodeIterator.item(&result);
		MayaStatusCheck(result);
		if(!analysisMaterial(materialObject)){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// }eẢ
bool TranslationMaterialManager::analysisMaterial(const MObject& materialObject){
	MStatus result;
	MFnDependencyNode materialNode(materialObject, &result);
	MayaStatusCheck(result);
	// TypeID`FbN
	MTypeId typeID = materialNode.typeId(&result);
	MayaStatusCheck(result);
	// }eÂӂ邢킯
	if(typeID != LampBasicMaterial::id){
		return true;
	}
	// Ȍd`FbN
	String materialName = materialNode.name(&result).asChar();
	MayaStatusCheck(result);
	TranslationMaterial* exist = database_.get(materialName);
	if(exist != NULL){
		MayaErrorOut(String("TranslationMaterialManager::analysisMaterial() "
			"OdĂ܂ ") + materialName);
		return false;
	}
	// }eA\z
	TranslationMaterial* material = NULL;
	if(typeID == LampBasicMaterial::id){
		material = new TranslationBasicMaterial(materialObject, materialName);
	}
	if(!material->analyze()){
		delete material;
		return false;
	}
	database_.put(materialName, material);
	array_.add(material);
	return true;
}
//------------------------------------------------------------------------------
// Lampւ̕ϊ
bool TranslationMaterialManager::convertToLamp(Scene* scene) const{
	for(int i = 0; i < getCount(); i++){
		if(!get(i)->convertToLamp(scene)){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// NA
int TranslationMaterialManager::clear(){
	int result = getCount();
	// vf̍폜
	for(int i = 0; i < result; i++){ delete array_.get(i); }
	array_.clear();
	database_.clear();
	return result;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
