//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊ}eAwb_
 * @author Junpee
 */

#ifndef TRANSLATION_MATERIAL_H_
#define TRANSLATION_MATERIAL_H_

namespace Lamp{
	class Scene;
	class Material;
}

namespace LampForMaya{

class TranslationBasicMaterial;

//------------------------------------------------------------------------------
/**
 * ϊ}eA
 */
class TranslationMaterial{
friend class TranslationMaterialManager;
public:
	/**
	 * fXgN^
	 */
	virtual ~TranslationMaterial();

	/**
	 * 
	 * @return true
	 */
	virtual bool analyze() = 0;

	/**
	 * Lampւ̕ϊ
	 * @param scene V[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene) = 0;

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * {}eAǂ
	 * @return {}eAȂtrue
	 */
	virtual bool isBasicMaterial() const{ return false; }

	/**
	 * {}eAւ̃LXg
	 * @return {}eAB^ႦNULLԂB
	 */
	virtual TranslationBasicMaterial* castBasicMaterial() const{
		if(isBasicMaterial()){
			return (TranslationBasicMaterial*)this;
		}
		return NULL;
	}

	//--------------------------------------------------------------------------

protected:
	/**
	 * RXgN^
	 * @param initializeObject IuWFNg
	 * @param initializeName 閼O
	 */
	TranslationMaterial(
		const MObject& initializeObject, const String& initializeName);

	/**
	 * }eA̕
	 * @return true
	 */
	virtual bool analyzeMaterial();

	/**
	 * }eÃRo[g
	 * @param material }eA
	 * @return true
	 */
	virtual bool convertMaterial(Material* material);

	/// IuWFNg
	MObject object_;
	/// O
	String name_;
	/// uh[h
	int blendMode_;
	/// At@
	float alpha_;
	/// uh\[X
	int blendSource_;
	/// uhfXeBl[V
	int blendDestination_;
	/// Z
	bool zWrite_;
	/// ZeXg
	bool zTestlag_;
	/// tHOIvV
	int fogOption_;
	/// Cg}XN
	u_int lightMask_;
	/// Dx
	int priority_;

private:
	// Rs[RXgN^̉B
	TranslationMaterial(const TranslationMaterial& copy);

	// Rs[̉B
	void operator =(const TranslationMaterial& copy);


};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_MATERIAL_H_
//------------------------------------------------------------------------------

