//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊ}eA
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Material/TranslationMaterial.h"
#include "Graphics/Material/Material.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationMaterial::TranslationMaterial(
	const MObject& initializeObject, const String& initializeName) :
	object_(initializeObject), name_(initializeName){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationMaterial::~TranslationMaterial(){
}
//------------------------------------------------------------------------------
// }eA̕
bool TranslationMaterial::analyzeMaterial(){
	// uh[h
	blendMode_ = MayaAttributeUtility::getInt(object_, "blendMode");
	// At@
	alpha_ = MayaAttributeUtility::getFloat(object_, "alpha");
	// uh\[X
	blendSource_ = MayaAttributeUtility::getInt(object_, "blendSource");
	// uhfXeBl[V
	blendDestination_ =
		MayaAttributeUtility::getInt(object_, "blendDestination");
	// Z
	zWrite_ = MayaAttributeUtility::getBool(object_, "zWrite");
	// ZeXg
	zTestlag_ = MayaAttributeUtility::getBool(object_, "zTest");
	// tHOIvV
	fogOption_ = MayaAttributeUtility::getInt(object_, "fogOption");
	// Cg}XN
	lightMask_ = MayaAttributeUtility::getInt(object_, "lightMask");
	// Dx
	priority_ = MayaAttributeUtility::getInt(object_, "priority");
	return true;
}
//------------------------------------------------------------------------------
// }eÃRo[g
bool TranslationMaterial::convertMaterial(Material* material){
	material->setBlendMode((Material::BlendMode)blendMode_);
	material->setAlpha(alpha_);
	material->setBlendSource((Material::BlendState)blendSource_);
	material->setBlendDestination((Material::BlendState)blendDestination_);
	material->setZWrite(zWrite_);
	material->setZTest(zTestlag_);
	material->setFogOption((Material::FogOption)fogOption_);
	material->setLightMask(lightMask_);
	material->setPriority(priority_);
	return true;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
