//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊ{}eAwb_
 * @author Junpee
 */

#ifndef TRANSLATION_BASIC_MATERIAL_H_
#define TRANSLATION_BASIC_MATERIAL_H_

#include <Translator/Material/TranslationMaterial.h>

namespace LampForMaya{

//------------------------------------------------------------------------------
/**
 * ϊ{}eA
 */
class TranslationBasicMaterial : public TranslationMaterial{
friend class TranslationMaterialManager;
public:
	/**
	 * fXgN^
	 */
	virtual ~TranslationBasicMaterial();

	/**
	 * {}eAǂ
	 * @return {}eAȂtrue
	 */
	virtual bool isBasicMaterial() const{ return true; }

	/**
	 * 
	 * @return true
	 */
	virtual bool analyze();

	/**
	 * Lampւ̕ϊ
	 * @param scene V[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene);

private:
	/**
	 * RXgN^
	 * @param initializeObject IuWFNg
	 * @param initializeName 閼O
	 */
	explicit TranslationBasicMaterial(
		const MObject& initializeObject, const String& initializeName);

	// Rs[RXgN^̉B
	TranslationBasicMaterial(const TranslationBasicMaterial& copy);

	// Rs[̉B
	void operator =(const TranslationBasicMaterial& copy);

	// x[XeNX`
	String baseTextureName_;
	// x[XUVCfbNX
	int baseUVIndex_;
	// eNX`
	String glossTextureName_;
	// UVCfbNX
	int glossUVIndex_;
	// CgeNX`
	String lightTextureName_;
	// CgUVCfbNX
	int lightUVIndex_;
	// eNX`
	String stainTextureName_;
	// UVCfbNX
	int stainUVIndex_;

	// fBt[YJ[
	Color3f diffuseColor_;
	// XyLJ[
	Color3f specularColor_;
	// XyLp[
	float specularPower_;
	// ArGgJ[
	Color3f ambientColor_;
	// G~bVuJ[
	Color3f emissiveColor_;

};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_BASIC_MATERIAL_H_
//------------------------------------------------------------------------------

