//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊ{}eA
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Material/TranslationBasicMaterial.h"
#include "Material/Utility/LampMaterialUtility.h"
#include "Graphics/Scene/Scene.h"
#include "Graphics/Material/MaterialManager.h"
#include "Graphics/Texture/TextureManager.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationBasicMaterial::TranslationBasicMaterial(
	const MObject& initializeObject, const String& initializeName) :
	TranslationMaterial(initializeObject, initializeName){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationBasicMaterial::~TranslationBasicMaterial(){
}
//------------------------------------------------------------------------------
// 
bool TranslationBasicMaterial::analyze(){
	// }eA̕
	if(!analyzeMaterial()){ return false; }
	// x[XeNX`
	baseTextureName_ = LampMaterialUtility::getTextureName(object_, "color");
	// x[XUVCfbNX
	baseUVIndex_ = MayaAttributeUtility::getInt(object_, "baseUVIndex");
	// eNX`
	glossTextureName_ =
		LampMaterialUtility::getTextureName(object_, "glossTexture");
	// UVCfbNX
	glossUVIndex_ = MayaAttributeUtility::getInt(object_, "glossUVIndex");
	// CgeNX`
	lightTextureName_ =
		LampMaterialUtility::getTextureName(object_, "lightTexture");
	// CgUVCfbNX
	lightUVIndex_ = MayaAttributeUtility::getInt(object_, "lightUVIndex");
	// eNX`
	stainTextureName_ =
		LampMaterialUtility::getTextureName(object_, "stainTexture");
	// UVCfbNX
	stainUVIndex_ = MayaAttributeUtility::getInt(object_, "stainUVIndex");

	// fBt[YJ[
	diffuseColor_ = MayaAttributeUtility::getColor3f(object_, "diffuseColor");
	// XyLJ[
	specularColor_ = MayaAttributeUtility::getColor3f(object_, "specularColor");
	// XyLp[
	specularPower_ = MayaAttributeUtility::getFloat(object_, "specularPower");
	// ArGgJ[
	ambientColor_ = MayaAttributeUtility::getColor3f(object_, "ambientColor");
	// G~bVuJ[
	emissiveColor_ = MayaAttributeUtility::getColor3f(object_, "emissiveColor");
	return true;
}
//------------------------------------------------------------------------------
// Lampւ̕ϊ
bool TranslationBasicMaterial::convertToLamp(Scene* scene){
	MaterialManager* materialManager = scene->getMaterialManager();
	BasicMaterial* material = materialManager->createBasicMaterial(name_);
	TextureManager* textureManager = scene->getTextureManager();
	// }eA̕ϊ
	if(!convertMaterial(material)){ return false; }
	// x[XeNX`
	if(!baseTextureName_.isEmpty()){
		Texture* baseTexture = textureManager->search(baseTextureName_);
		if(baseTexture == NULL){
			MayaErrorOut("TranslationBasicMaterial::convertToLamp() "
				"x[XeNX`܂ " + baseTextureName_);
			return false;
		}
		material->setBaseTexture(baseTexture);
	}
	// x[XUVCfbNX
	material->setBaseUVIndex(baseUVIndex_);
	// eNX`
	if(!glossTextureName_.isEmpty()){
		Texture* glossTexture = textureManager->search(glossTextureName_);
		if(glossTexture == NULL){
			MayaErrorOut("TranslationBasicMaterial::convertToLamp() "
				"eNX`܂ " + glossTextureName_);
			return false;
		}
		material->setGlossTexture(glossTexture);
	}
	// UVCfbNX
	material->setGlossUVIndex(glossUVIndex_);
	// CgeNX`
	if(!lightTextureName_.isEmpty()){
		Texture* lightTexture = textureManager->search(lightTextureName_);
		if(lightTexture == NULL){
			MayaErrorOut("TranslationBasicMaterial::convertToLamp() "
				"CgeNX`܂ " + lightTextureName_);
			return false;
		}
		material->setLightTexture(lightTexture);
	}
	// CgUVCfbNX
	material->setLightUVIndex(lightUVIndex_);
	// eNX`
	if(!stainTextureName_.isEmpty()){
		Texture* stainTexture = textureManager->search(stainTextureName_);
		if(stainTexture == NULL){
			MayaErrorOut("TranslationBasicMaterial::convertToLamp() "
				"eNX`܂ " + stainTextureName_);
			return false;
		}
		material->setStainTexture(stainTexture);
	}
	// UVCfbNX
	material->setStainUVIndex(stainUVIndex_);

	// fBt[YJ[
	material->setDiffuseColor(diffuseColor_);
	// XyLJ[
	material->setSpecularColor(specularColor_);
	// XyLp[
	material->setSpecularPower(specularPower_);
	// ArGgJ[
	material->setAmbientColor(ambientColor_);
	// G~bVuJ[
	material->setEmissiveColor(emissiveColor_);
	return true;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
