//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊ|CgCgwb_
 * @author Junpee
 */

#ifndef TRANSLATION_POINT_LIHGT_H_
#define TRANSLATION_POINT_LIHGT_H_

#include <Translator/Light/TranslationLight.h>

namespace LampForMaya{

//------------------------------------------------------------------------------
/**
 * ϊ|CgCg
 */
class TranslationPointLight : public TranslationLight{
friend class TranslationLightManager;
public:
	/**
	 * fXgN^
	 */
	virtual ~TranslationPointLight();

	/**
	 * |CgCgǂ
	 * @return |CgCgȂtrue
	 */
	virtual bool isPointLight() const{ return true; }

	/**
	 * 
	 * @return true
	 */
	virtual bool analyze();

	/**
	 * Lampւ̕ϊ
	 * @param scene V[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene);

private:
	/**
	 * RXgN^
	 * @param initializeDagPath DagpX
	 * @param initializeName 閼O
	 */
	explicit TranslationPointLight(
		const MDagPath& initializeDagPath, const String& initializeName);

	// Rs[RXgN^̉B
	TranslationPointLight(const TranslationPointLight& copy);

	// Rs[̉B
	void operator =(const TranslationPointLight& copy);

	// ʒu
	Vector3 position_;
	// W
	int decayRate_;

};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_POINT_LIHGT_H_
//------------------------------------------------------------------------------

