//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊ|CgCg
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Light/TranslationPointLight.h"
#include "Graphics/Scene/Scene.h"
#include "Graphics/Light/LightManager.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationPointLight::TranslationPointLight(
	const MDagPath& initializeDagPath, const String& initializeName) :
	TranslationLight(initializeDagPath, initializeName){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationPointLight::~TranslationPointLight(){
}
//------------------------------------------------------------------------------
// 
bool TranslationPointLight::analyze(){
	// Cg̃AiCY
	if(!analyzeLight()){ return false; }
	MStatus result;
	String errorString;
	MFnPointLight lightShape(dagPath_.node(), &result);
	MayaStatusCheck(result);
	MFnTransform lightTransform(dagPath_.transform(), &result);
	MayaStatusCheck(result);
	// ʒu
	MMatrix worldMatrix = lightTransform.transformationMatrix(&result);
	MayaStatusCheck(result);
	position_.set(
		(float)worldMatrix.matrix[3][0],
		(float)worldMatrix.matrix[3][1],
		(float)worldMatrix.matrix[3][2]);
	position_.set(0.f, 0.f, 0.f);
	// W
	decayRate_ = lightShape.decayRate(&result);
	MayaStatusCheck(result);
	return true;
}
//------------------------------------------------------------------------------
// Lampւ̕ϊ
bool TranslationPointLight::convertToLamp(Scene* scene){
	LightManager* lightManager = scene->getLightManager();
	PointLight* light = lightManager->createPointLight(name_);
	light->setColor(exportColor_);
	light->setLightMask(lightMask_);
	light->setEnabled(visibility_);
	light->setPosition(position_);
	light->setRange(calcRange(decayRate_));
	if(decayRate_ == 0){
		light->setAttenuation(1.f, 0.f, 0.f);
	}else if(decayRate_ == 1){
		light->setAttenuation(0.f, 1.f, 0.f);
	}else if(decayRate_ == 2){
		light->setAttenuation(0.f, 0.f, 1.f);
	}else{
		MayaErrorOut(String("TranslationPointLight::convertToLamp() ") +
			name_ + "ɃT|[gĂȂWݒ肳Ă܂");
		return false;
	}
	return true;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
