//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊCg}l[Wwb_
 * @author Junpee
 */

#ifndef TRANSLATION_LIGHT_MANAGER_H_
#define TRANSLATION_LIGHT_MANAGER_H_

#include <Core/Container/HashMap.h>
#include <Core/Container/ArrayList.h>
#include <Translator/Light/TranslationAmbientLight.h>
#include <Translator/Light/TranslationDirectionalLight.h>
#include <Translator/Light/TranslationPointLight.h>

namespace LampForMaya{

//------------------------------------------------------------------------------
/**
 * ϊCg}l[W
 */
class TranslationLightManager{
public:
	/**
	 * RXgN^
	 */
	TranslationLightManager();

	/**
	 * fXgN^
	 */
	virtual ~TranslationLightManager();

	/**
	 * Cg̎W
	 * @return true
	 */
	virtual bool collectLights();

	/**
	 * Lampւ̕ϊ
	 * @param scene ϊV[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene) const;

	/**
	 * NA
	 * @return 폜IuWFNg
	 */
	virtual int clear();

	/**
	 * Cg̎擾
	 * @return Cg
	 */
	virtual int getCount() const{ return array_.getCount(); }

	/**
	 * Cg̎擾
	 * @param index Cg̃CfNX
	 * @return Cg
	 */
	virtual TranslationLight* get(int index) const{
		return array_.get(index);
	}

	/**
	 * Cǧ
	 * @param name 郉Cg
	 * @return Cg
	 */
	virtual TranslationLight* search(String name) const{
		return database_.get(name);
	}

protected:
	/**
	 * Cg̉
	 * @param dagPath DAGpX
	 * @return true
	 */
	virtual bool analysisLight(const MDagPath& dagPath);

private:
	// Rs[RXgN^̉B
	TranslationLightManager(const TranslationLightManager& copy);

	// Rs[̉B
	void operator =(const TranslationLightManager& copy);

	// Cgf[^x[X
	Lamp::HashMap<String, TranslationLight*> database_;
	// Cgz
	ArrayList<TranslationLight*> array_;

};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_LIGHT_MANAGER_H_
//------------------------------------------------------------------------------
