//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊCg}l[W
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Light/TranslationLightManager.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationLightManager::TranslationLightManager() :
	database_(256, 0.75f), array_(256){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationLightManager::~TranslationLightManager(){
	Assert(database_.getCount() == 0);
	Assert(array_.getCount() == 0);
	if(getCount() != 0){ clear(); }
}
//------------------------------------------------------------------------------
// Cg̎W
bool TranslationLightManager::collectLights(){
	MStatus result;
	MItDag dagIterator(MItDag::kBreadthFirst, MFn::kLight, &result);
	MayaStatusCheck(result);
	MDagPath dagPath;
	for( ; !dagIterator.isDone(); dagIterator.next()){
		result = dagIterator.getPath(dagPath);
		MayaStatusCheck(result);
		MFnDagNode dagNode(dagPath, &result);
		MayaStatusCheck(result);
		// O̎擾
		MString dagName = dagNode.name(&result);
		MayaStatusCheck(result);
		// CgłȂ΃LZ
		if(!dagPath.hasFn(MFn::kLight)){ continue; }
		// ԃIuWFNgȂLZ
		if(dagNode.isIntermediateObject()){ continue; }
		// Cg̉
		if(!analysisLight(dagPath)){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// Cg̉
bool TranslationLightManager::analysisLight(const MDagPath& dagPath){
	MStatus result;
	MFnDagNode lightNode(dagPath, &result);
	MayaStatusCheck(result);
	if(	(!dagPath.hasFn(MFn::kAmbientLight)) &&
		(!dagPath.hasFn(MFn::kDirectionalLight)) &&
		(!dagPath.hasFn(MFn::kPointLight)) ){ return true; }
	// IuWFNg̎擾
	MObject lightObject = dagPath.node(&result);
	MayaStatusCheck(result);
	// Ȍd`FbN
	String lightName = lightNode.name(&result).asChar();
	MayaStatusCheck(result);
	TranslationLight* exist = database_.get(lightName);
	if(exist != NULL){
		// IuWFNgȂCX^XȂ̂œǂݔ΂AłȂ΃G[
		if(exist->getObject() != lightObject){
			MayaErrorOut(String("TranslationLightManager::analysisModel() "
				"OdĂ܂ ") + lightName);
			return false;
		}
		return true;
	}
	// Cg\z
	TranslationLight* light = NULL;
	if(dagPath.hasFn(MFn::kAmbientLight)){
		light = new TranslationAmbientLight(dagPath, lightName);
	}else if(dagPath.hasFn(MFn::kDirectionalLight)){
		light = new TranslationDirectionalLight(dagPath, lightName);
	}else if(dagPath.hasFn(MFn::kPointLight)){
		light = new TranslationPointLight(dagPath, lightName);
	}
	if(!light->analyze()){
		delete light;
		return false;
	}
	database_.put(lightName, light);
	array_.add(light);
	return true;
}
//------------------------------------------------------------------------------
// Lampւ̕ϊ
bool TranslationLightManager::convertToLamp(Scene* scene) const{
	for(int i = 0; i < getCount(); i++){
		if(!get(i)->convertToLamp(scene)){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// NA
int TranslationLightManager::clear(){
	int result = getCount();
	// vf̍폜
	for(int i = 0; i < result; i++){ delete array_.get(i); }
	array_.clear();
	database_.clear();
	return result;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
