//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊCgwb_
 * @author Junpee
 */

#ifndef TRANSLATION_LIGHT_H_
#define TRANSLATION_LIGHT_H_

namespace Lamp{
	class Scene;
}

namespace LampForMaya{

class TranslationAmbientLight;
class TranslationDirectionalLight;
class TranslationPointLight;

//------------------------------------------------------------------------------
/**
 * ϊCg
 */
class TranslationLight{
friend class TranslationLightManager;
public:
	/**
	 * fXgN^
	 */
	virtual ~TranslationLight();

	/**
	 * 
	 * @return true
	 */
	virtual bool analyze() = 0;

	/**
	 * Lampւ̕ϊ
	 * @param scene V[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene) = 0;

	/**
	 * IuWFNg̎擾
	 * @return IuWFNg
	 */
	virtual MObject getObject() const{ return object_; }

	/**
	 * O̎擾
	 * @return O
	 */
	virtual String getName() const{ return name_; }

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * ArGgCgǂ
	 * @return ArGgCgȂtrue
	 */
	virtual bool isAmbientLight() const{ return false; }

	/**
	 * ArGgCgւ̃LXg
	 * @return ArGgCgB^ႦNULLԂB
	 */
	virtual TranslationAmbientLight* castAmbientLight() const{
		if(isAmbientLight()){
			return (TranslationAmbientLight*)this;
		}
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * fBNViCgǂ
	 * @return fBNViCgȂtrue
	 */
	virtual bool isDirectionalLight() const{ return false; }

	/**
	 * fBNViCgւ̃LXg
	 * @return fBNViCgB^ႦNULLԂB
	 */
	virtual TranslationDirectionalLight* castDirectionalLight() const{
		if(isDirectionalLight()){
			return (TranslationDirectionalLight*)this;
		}
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * |CgCgǂ
	 * @return |CgCgȂtrue
	 */
	virtual bool isPointLight() const{ return false; }

	/**
	 * |CgCgւ̃LXg
	 * @return |CgCgB^ႦNULLԂB
	 */
	virtual TranslationPointLight* castPointLight() const{
		if(isPointLight()){
			return (TranslationPointLight*)this;
		}
		return NULL;
	}

	//--------------------------------------------------------------------------

protected:
	/**
	 * RXgN^
	 * @param initializeDagPath DagpX
	 * @param initializeName 閼O
	 */
	TranslationLight(
		const MDagPath& initializeDagPath, const String& initializeName);

	/**
	 * Cg̕
	 */
	virtual bool analyzeLight();

	/**
	 * W̌vZ
	 * @param decayRate 
	 * @return W
	 */
	virtual float calcRange(int decayRate){
		// 
		if(decayRate == 0){
			return 1.84467435e+019f;
		}
		// PxƂ
		float luminance = exportColor_.r * 0.298912f +
			exportColor_.g * 0.586611f + exportColor_.b * 0.114477f;
		// ꎟ
		if(decayRate == 1){
			return minimumLightPower * luminance;
		// 񎟌
		}else if(decayRate == 2){
			return Math::sqrt(minimumLightPower * luminance);
		}
		return 0.f;
	}

	/// DagpX
	MDagPath dagPath_;
	/// IuWFNg
	MObject object_;
	/// O
	String name_;
	/// CgJ[
	Color3f color_;
	/// o̓J[
	Color3f exportColor_;
	/// Cgx
	float intensity_;
	/// Cg}XN
	int lightMask_;
	/// \tO
	bool visibility_;

	/// ŏCgx
	static float minimumLightPower;

private:
	// Rs[RXgN^̉B
	TranslationLight(const TranslationLight& copy);

	// Rs[̉B
	void operator =(const TranslationLight& copy);

};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_LIGHT_H_
//------------------------------------------------------------------------------

