//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊCg
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Light/TranslationLight.h"

namespace LampForMaya{

/// ŏCgx
float TranslationLight::minimumLightPower = 256.f / 16.f;

//------------------------------------------------------------------------------
// RXgN^
TranslationLight::TranslationLight(
	const MDagPath& initializeDagPath, const String& initializeName) :
	dagPath_(initializeDagPath), name_(initializeName){
	MStatus result;
	// IuWFNg̎擾
	object_ = dagPath_.node(&result);
	MayaStatusCheck(result);
}
//------------------------------------------------------------------------------
// fXgN^
TranslationLight::~TranslationLight(){
}
//------------------------------------------------------------------------------
// Cg̕
bool TranslationLight::analyzeLight(){
	MStatus result;
	String errorString;
	MFnLight lightShape(dagPath_.node(), &result);
	MayaStatusCheck(result);

	// CgJ[
	MColor color = lightShape.color(&result);
	MayaStatusCheck(result);
	color_.set(color.r, color.g, color.b);

	// Cgx
	intensity_ = lightShape.intensity(&result);
	MayaStatusCheck(result);

	// o̓J[Zo
	exportColor_.set(color_.r * intensity_,
		color_.g * intensity_, color_.b * intensity_);

	// Cg}XN
	lightMask_ = 1;
	lightShape.attribute("LampLightMask", &result);
	if(result){
		// LightShapeLampLightMaskAgr[gǉ
		lightMask_ = MayaAttributeUtility::getInt(object_, "LampLightMask");
	}

	// \tO
	visibility_ = MayaAttributeUtility::getBool(object_, "visibility");

	return true;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
