//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊfBNViCg
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Light/TranslationDirectionalLight.h"
#include "Graphics/Scene/Scene.h"
#include "Graphics/Light/LightManager.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationDirectionalLight::TranslationDirectionalLight(
	const MDagPath& initializeDagPath, const String& initializeName) :
	TranslationLight(initializeDagPath, initializeName){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationDirectionalLight::~TranslationDirectionalLight(){
}
//------------------------------------------------------------------------------
// 
bool TranslationDirectionalLight::analyze(){
	// Cg̃AiCY
	if(!analyzeLight()){ return false; }
	MStatus result;
	String errorString;
	MFnDirectionalLight lightShape(dagPath_.node(), &result);
	MayaStatusCheck(result);
	MFloatVector direction =
		lightShape.lightDirection(0, MSpace::kWorld, &result);
	// Ȃ@\Ȃ
//	MFloatVector direction =
//		lightShape.lightDirection(0, MSpace::kObject, &result);
	MayaStatusCheck(result);
	direction_.set(direction.x, direction.y, direction.z);
	// SceneNode̕ϊgp
	direction_.set(0.f, 0.f, -1.f);
	return true;
}
//------------------------------------------------------------------------------
// Lampւ̕ϊ
bool TranslationDirectionalLight::convertToLamp(Scene* scene){
	LightManager* lightManager = scene->getLightManager();
	DirectionalLight* light = lightManager->createDirectionalLight(name_);
	light->setColor(exportColor_);
	light->setLightMask(lightMask_);
	light->setEnabled(visibility_);
	light->setDirection(direction_);
	return true;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
