//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊArGgCg
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Light/TranslationAmbientLight.h"
#include "Graphics/Scene/Scene.h"
#include "Graphics/Light/LightManager.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationAmbientLight::TranslationAmbientLight(
	const MDagPath& initializeDagPath, const String& initializeName) :
	TranslationLight(initializeDagPath, initializeName){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationAmbientLight::~TranslationAmbientLight(){
}
//------------------------------------------------------------------------------
// 
bool TranslationAmbientLight::analyze(){
	// Cg̃AiCY
	if(!analyzeLight()){ return false; }
	MStatus result;
	String errorString;
	MFnAmbientLight lightShape(dagPath_.node(), &result);
	MayaStatusCheck(result);
	// ArGgVF[h
	float ambientShade = lightShape.ambientShade(&result);
	MayaStatusCheck(result);
	if(ambientShade != 0.f){
		errorString.format("TranslationAmbientLight::analyze() "
			"%sambientShadeAgr[g0ł܂ ( %f )",
			name_.getBytes(), ambientShade);
		MayaErrorOut(errorString);
		return false;
	}
	return true;
}
//------------------------------------------------------------------------------
// Lampւ̕ϊ
bool TranslationAmbientLight::convertToLamp(Scene* scene){
	LightManager* lightManager = scene->getLightManager();
	AmbientLight* light = lightManager->createAmbientLight(name_);
	light->setColor(exportColor_);
	light->setLightMask(lightMask_);
	light->setEnabled(visibility_);
	return true;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
