//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊV[m[hCX^Xwb_
 * @author Junpee
 */

#ifndef TRANSLATION_SCENE_NODE_INSTANCE_H_
#define TRANSLATION_SCENE_NODE_INSTANCE_H_

#include "Translator/Instance/TranslationInstance.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
/**
 * ϊV[m[hCX^X
 */
class TranslationSceneNodeInstance : public TranslationInstance{
friend class TranslationInstanceManager;
public:
	/**
	 * fXgN^
	 */
	virtual ~TranslationSceneNodeInstance();

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return true
	 */
	virtual bool analyze();

	//--------------------------------------------------------------------------
	/**
	 * Lampւ̕ϊ
	 * @param scene V[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene);

	/**
	 * Aj[V̕ϊ
	 * @param animationManager Aj[V}l[W
	 * @param animationSet Aj[VZbg
	 * @return true
	 */
	virtual bool convertAnimation(
		AnimationManager* animationManager, AnimationSet* animationSet){
		return convertSceneNodeAnimation(
			animationManager, animationSet, source_, destination_);
	}

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * ϊV[m[hCX^Xǂ
	 * @return ϊV[m[hCX^XȂtrue
	 */
	virtual bool isTranslationSceneNodeInstance() const{ return true; }

protected:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param initializePath DagpX
	 * @param initializeName 閼O
	 */
	TranslationSceneNodeInstance(
		const MDagPath& initializePath, const String& initializeName);

	/**
	 * [`FbN
	 * @param point `FbN|Cg
	 * @return |Cg0ȂtrueԂ
	 */
	virtual bool zeroCheck(const MPoint& point){
		if(	(Math::abs((float)point.x) > Math::epsilon) ||
			(Math::abs((float)point.y) > Math::epsilon) ||
			(Math::abs((float)point.z) > Math::epsilon)){
			return false;
		}
		return true;
	}

	/// Rs[
	SceneNode* source_;
	/// Rs[
	SceneNode* destination_;
	/// s{bg
	Vector3 pivot_;
	/// XP[
	Vector3 scale_;
	/// ]
	Vector3 rotation_;
	/// ړ
	Vector3 translation_;

};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_SCENE_NODE_INSTANCE_H_
//------------------------------------------------------------------------------
