//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊfCX^X
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Instance/TranslationModelInstance.h"
#include "Graphics/Model/ModelManager.h"
#include "Graphics/SceneNode/SceneNodeManager.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationModelInstance::TranslationModelInstance(
	const MDagPath& initializePath, const String& initializeName) :
	TranslationInstance(initializePath, initializeName),
	source_(NULL), destination_(NULL){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationModelInstance::~TranslationModelInstance(){
}
//------------------------------------------------------------------------------
// Lampւ̕ϊ
bool TranslationModelInstance::convertToLamp(Scene* scene){
	// eV[m[ȟ
	SceneNodeManager* sceneNodeManager = scene->getSceneNodeManager();
	SceneNode* target = sceneNodeManager->search(parentSceneNodeName_);
	if(target == NULL){
		MayaErrorOut(String("TranslationModelInstance::convertToLamp() "
			"CX^X̃V[m[h܂ ") +
			parentSceneNodeName_);
		return false;
	}

	// fCX^X
	ModelManager* modelManager = scene->getModelManager();
	Model* model = modelManager->search(name_);
	if(model == NULL){
		MayaErrorOut(String("TranslationModelInstance::convertToLamp() "
			"CX^X̃f" + name_ + "܂ ") +
			parentSceneNodeName_);
		return false;
	}
	source_ = model;
	Model* copyModel = model->copyModel(0);
	destination_ = copyModel;

	// l̃Rs[
	copyModel->setEnabled(visibility_);
	target->addSceneLeaf(copyModel);
	return true;
}
//------------------------------------------------------------------------------
// Aj[V̕ϊ
bool TranslationModelInstance::convertAnimation(
	AnimationManager* animationManager, AnimationSet* animationSet){
	return convertSceneLeafAnimation(
		animationManager, animationSet, source_, destination_);
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
