//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊCgCX^Xwb_
 * @author Junpee
 */

#ifndef TRANSLATION_LIGHT_INSTANCE_H_
#define TRANSLATION_LIGHT_INSTANCE_H_

#include "Translator/Instance/TranslationInstance.h"

namespace Lamp{
	class Light;
}

namespace LampForMaya{

//------------------------------------------------------------------------------
/**
 * ϊCgCX^X
 */
class TranslationLightInstance : public TranslationInstance{
friend class TranslationInstanceManager;
public:
	/**
	 * fXgN^
	 */
	virtual ~TranslationLightInstance();

	//--------------------------------------------------------------------------
	/**
	 * Lampւ̕ϊ
	 * @param scene V[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene);

	/**
	 * Aj[V̕ϊ
	 * @param animationManager Aj[V}l[W
	 * @param animationSet Aj[VZbg
	 * @return true
	 */
	virtual bool convertAnimation(
		AnimationManager* animationManager, AnimationSet* animationSet);

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * ϊCgCX^Xǂ
	 * @return ϊCgCX^XȂtrue
	 */
	virtual bool isTranslationLightInstance() const{ return true; }

protected:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param initializePath DagpX
	 * @param initializeName 閼O
	 */
	TranslationLightInstance(
		const MDagPath& initializePath, const String& initializeName);

	/// Rs[
	Light* source_;
	/// Rs[
	Light* destination_;

};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_LIGHT_INSTANCE_H_
//------------------------------------------------------------------------------
