//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊCgCX^X
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Instance/TranslationLightInstance.h"
#include "Graphics/Light/LightManager.h"
#include "Graphics/SceneNode/SceneNodeManager.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationLightInstance::TranslationLightInstance(
	const MDagPath& initializePath, const String& initializeName) :
	TranslationInstance(initializePath, initializeName),
	source_(NULL), destination_(NULL){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationLightInstance::~TranslationLightInstance(){
}
//------------------------------------------------------------------------------
// Lampւ̕ϊ
bool TranslationLightInstance::convertToLamp(Scene* scene){
	// eV[m[ȟ
	SceneNodeManager* sceneNodeManager = scene->getSceneNodeManager();
	SceneNode* target = sceneNodeManager->search(parentSceneNodeName_);
	if(target == NULL){
		MayaErrorOut(String("TranslationLightInstance::convertToLamp() "
			"CX^X̃V[m[h܂ ") +
			parentSceneNodeName_);
		return false;
	}

	// fCX^X
	LightManager* lightManager = scene->getLightManager();
	Light* light = lightManager->search(name_);
	if(light == NULL){
		MayaErrorOut(String("TranslationLightInstance::convertToLamp() "
			"CX^X̃f" + name_ + "܂ ") +
			parentSceneNodeName_);
		return false;
	}
	source_ = light;
	Light* copyLight = light->copyLight();
	destination_ = copyLight;

	// l̃Rs[
	copyLight->setEnabled(visibility_);
	target->addSceneLeaf(copyLight);
	return true;
}
//------------------------------------------------------------------------------
// Aj[V̕ϊ
bool TranslationLightInstance::convertAnimation(
	AnimationManager* animationManager, AnimationSet* animationSet){
	return convertSceneLeafAnimation(
		animationManager, animationSet, source_, destination_);
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
