//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊCX^X}l[Wwb_
 * @author Junpee
 */

#ifndef TRANSLATION_INSTANCE_MANAGER_H_
#define TRANSLATION_INSTANCE_MANAGER_H_

#include <Core/Container/ArrayList.h>
#include <Translator/Instance/TranslationInstance.h>

namespace Lamp{
	class SceneNode;
}

namespace LampForMaya{

//------------------------------------------------------------------------------
/**
 * ϊCX^X}l[W
 */
class TranslationInstanceManager{
public:
	/**
	 * RXgN^
	 */
	TranslationInstanceManager();

	/**
	 * fXgN^
	 */
	virtual ~TranslationInstanceManager();

	/**
	 * CX^X̎W
	 * @return true
	 */
	virtual bool collectInstances();

	/**
	 * Lampւ̕ϊ
	 * @param scene ϊV[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene);

	/**
	 * Aj[V̕ϊ
	 * @param animationManager Aj[V}l[W
	 * @param animationSet Aj[VZbg
	 * @return true
	 */
	virtual bool convertAnimation(
		AnimationManager* animationManager, AnimationSet* animationSet);

	/**
	 * NA
	 * @return 폜IuWFNg
	 */
	virtual int clear();

	/**
	 * CX^X̎擾
	 * @return CX^X
	 */
	virtual int getCount() const{ return array_.getCount(); }

	/**
	 * CX^X̎擾
	 * @param index CX^X̃CfNX
	 * @return CX^X
	 */
	virtual TranslationInstance* get(int index) const{
		return array_.get(index);
	}

protected:
	/**
	 * CX^X̉
	 * @param dagPath DAGpX
	 * @return true
	 */
	virtual bool analysisInstance(MDagPath dagPath);

	/**
	 * łCX^X̌
	 * @param scene ϊV[
	 * @param instance CX^X
	 * @return CX^X
	 */
	virtual TranslationInstance* searchValidInstance(
		Scene* scene, TranslationInstance* instance);

	/**
	 * V[m[ȟ
	 * @param sceneNode ΏۃV[m[h
	 * @param targetName 閼O
	 * @return ÕV[m[hf݂true
	 */
	virtual bool searchSceneNode(
		SceneNode* sceneNode, const String& targetName);

private:
	// Rs[RXgN^̉B
	TranslationInstanceManager(const TranslationInstanceManager& copy);

	// Rs[̉B
	void operator =(const TranslationInstanceManager& copy);

	// CX^Xz
	ArrayList<TranslationInstance*> array_;
	// Ro[gς݃CX^Xz
	ArrayList<TranslationInstance*> convertedArray_;

};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_INSTANCE_MANAGER_H_
//------------------------------------------------------------------------------
