//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊCX^X}l[W
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Instance/TranslationInstanceManager.h"
#include "Translator/Instance/TranslationSceneNodeInstance.h"
#include "Translator/Instance/TranslationLightInstance.h"
#include "Translator/Instance/TranslationModelInstance.h"
#include "Translator/SceneNode/TranslationSceneNodeManager.h"
#include "Graphics/Scene/Scene.h"
#include "Graphics/SceneNode/SceneNodeManager.h"
#include "Graphics/Model/Model.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationInstanceManager::TranslationInstanceManager() :
	array_(256), convertedArray_(256){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationInstanceManager::~TranslationInstanceManager(){
	Assert(array_.getCount() == 0);
	Assert(convertedArray_.getCount() == 0);
	if((array_.getCount() != 0) || (convertedArray_.getCount() != 0)){
		clear();
	}
}
//------------------------------------------------------------------------------
// NA
int TranslationInstanceManager::clear(){
	int result = 0;
	// z̃NA
	int count = array_.getCount();
	Assert(count == 0);
	for(int i = 0; i < count; i++){ delete array_.get(i); }
	array_.clear();
	result += count;
	// Ro[gςݔz̃NA
	int convertedCount = convertedArray_.getCount();
	for(int i = 0; i < convertedCount; i++){ delete convertedArray_.get(i); }
	convertedArray_.clear();
	result += convertedCount;
	return result;
}
//------------------------------------------------------------------------------
// CX^X̎W
bool TranslationInstanceManager::collectInstances(){
	MStatus result;
	MItDag dagIterator(MItDag::kBreadthFirst, MFn::kInvalid, &result);
	MayaStatusCheck(result);
	MDagPath dagPath;
	for( ; !dagIterator.isDone(); dagIterator.next()){
		result = dagIterator.getPath(dagPath);
		MayaStatusCheck(result);
		MFnDagNode dagNode(dagPath, &result);
		MayaStatusCheck(result);
		// ŏKwȉɂȂ烋[v𔲂
		u_int length = dagPath.length(&result);
		MayaStatusCheck(result);
		if(length > 1){ break; }
		// LDagm[h`FbNAV[m[h̃`FbNgp
		if(!TranslationSceneNodeManager::checkValidDagNode(dagPath)){ 
			continue;
		}
		// ŏKwgXtH[t@NVĂȂ΃LZ
		// worldIuWFNg͂
		if(!dagPath.hasFn(MFn::kTransform)){ continue; }
		// OEhv[ȂLZ
		if(MayaDAGUtility::getName(dagPath) == "groundPlane_transform"){
			continue;
		}
		// CX^X̉
		if(!analysisInstance(dagPath)){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// CX^X̉
bool TranslationInstanceManager::analysisInstance(MDagPath dagPath){
	MStatus result;
	MFnDagNode dagNode(dagPath, &result);
	MayaStatusCheck(result);

	// CX^XIuWFNgǂ
	u_int instanceNumber = dagPath.instanceNumber(&result);
	MayaStatusCheck(result);
	if(instanceNumber > 0){
		// CX^XIuWFNg̍쐬Aȏ̎q͂ǂȂ
		String instanceName = MayaDAGUtility::getName(dagPath);
		TranslationInstance* instance;
		if(dagPath.hasFn(MFn::kTransform)){
			// V[m[hCX^X
			instance = new TranslationSceneNodeInstance(dagPath, instanceName);
		}else if(dagPath.hasFn(MFn::kLight)){
			// CgCX^X
			instance = new TranslationLightInstance(dagPath, instanceName);
		}else{
			// fCX^X
			instance = new TranslationModelInstance(dagPath, instanceName);
		}
		// eCX^X̉
		if(!instance->analyze()){
			delete instance;
			return false;
		}
		array_.add(instance);
		return true;
	}

	// CX^Xł͂Ȃ̂Ŏqǂ
	u_int length = dagPath.length(&result);
	MItDag childIterator(MItDag::kBreadthFirst, MFn::kInvalid, &result);
	MayaStatusCheck(result);
	result = childIterator.reset(
		dagPath, MItDag::kBreadthFirst, MFn::kInvalid);
	MayaStatusCheck(result);
	// gǂݔ΂
	childIterator.next();
	MDagPath childPath;
	for( ; !childIterator.isDone(); childIterator.next()){
		result = childIterator.getPath(childPath);
		MayaStatusCheck(result);
		// KwȉɂȂ烋[v𔲂
		u_int childLength = childPath.length(&result);
		MayaStatusCheck(result);
		if(childLength > length + 1){ break; }
		// LDagm[h`FbNAV[m[h̃`FbNgp
		if(!TranslationSceneNodeManager::checkValidDagNode(childPath)){ 
			continue;
		}
		// q̕
		analysisInstance(childPath);
	}
	return true;
}
//------------------------------------------------------------------------------
// Lampւ̕ϊ
//------------------------------------------------------------------------------
// Lampւ̕ϊ
bool TranslationInstanceManager::convertToLamp(Scene* scene){
	// Rs[т̎qSceneNode,ModelCX^XΏۂɂȂĂȂ
	//		CX^XΏۂɂȂĂ΁Aɓ`FbNɂ
	//		CX^XΏۂɂȂĂȂ΁ACX^X
	// SẴCX^XIuWFNgЕt܂ŌJԂ
	while(true){
		if(array_.getCount() == 0){ break; }
		TranslationInstance* instance =
			searchValidInstance(scene, array_.get(0));
		// CX^X̉s
		if(!instance->convertToLamp(scene)){ return false; }
		array_.removeByValue(instance);
		convertedArray_.add(instance);
	}
	return true;
}
//------------------------------------------------------------------------------
// CX^X̉
TranslationInstance* TranslationInstanceManager::searchValidInstance(
	Scene* scene, TranslationInstance* instance){
	SceneNodeManager* sceneNodeManager = scene->getSceneNodeManager();
	// V[m[hCX^XłȂȂ疳ŃCX^XsĂ悢
	if(!instance->isTranslationSceneNodeInstance()){ return instance; }
	// Rs[̃CX^X܂łȂ
	int instanceCount = array_.getCount();
	TranslationInstance* includeInstance = NULL;
	for(int i = 0; i < instanceCount; i++){
		TranslationInstance* target = array_.get(i);
		// g͖
		if(target == instance){ continue; }
		// IuWFNgCX^X悤ƂĂ鎞͖
		if(instance->getName() == target->getName()){ continue; }
		SceneNode* sceneNode = sceneNodeManager->search(instance->getName());
		if(searchSceneNode(sceneNode, target->getName())){
			// ^[QbgƓÕIuWFNg
			includeInstance = target;
			break;
		}
	}
	// ̃CX^Xɉ
	if(includeInstance != NULL){
		return searchValidInstance(scene, includeInstance);
	}
	return instance;
}
//------------------------------------------------------------------------------
// V[m[ȟ
bool TranslationInstanceManager::searchSceneNode(
	SceneNode* sceneNode, const String& targetName){
	if(sceneNode->getName().equals(targetName)){ return true; }
	// V[[ť
	int sceneLeafCount = sceneNode->getSceneLeafCount();
	for(int i = 0; i < sceneLeafCount; i++){
		SceneLeaf* sceneLeaf = sceneNode->getSceneLeaf(i);
		if(sceneLeaf->getName().equals(targetName)){ return true; }
	}
	// qV[m[ȟ
	int sceneNodeCount = sceneNode->getSceneNodeCount();
	for(int i = 0; i < sceneNodeCount; i++){
		bool result = searchSceneNode(sceneNode->getSceneNode(i), targetName);
		if(result){ return true; }
	}
	return false;
}
//------------------------------------------------------------------------------
// Aj[V
//------------------------------------------------------------------------------
// Aj[V̕ϊ
bool TranslationInstanceManager::convertAnimation(
	AnimationManager* animationManager, AnimationSet* animationSet){
	int count = convertedArray_.getCount();
	for(int i = 0; i < count; i++){
		if(!convertedArray_.get(i)->convertAnimation(
			animationManager, animationSet)){
			return false;
		}
	}
	return true;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
