//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊCX^Xwb_
 * @author Junpee
 */

#ifndef TRANSLATION_INSTANCE_H_
#define TRANSLATION_INSTANCE_H_

namespace Lamp{
	class Scene;
	class SceneNode;
	class SceneLeaf;
	class AnimationManager;
	class AnimationSet;
}

#include <Core/Container/ArrayList.h>

namespace LampForMaya{

class TranslationSceneNodeInstance;
class TranslationLightInstance;
class TranslationModelInstance;

//------------------------------------------------------------------------------
/**
 * ϊCX^X
 */
class TranslationInstance{
friend class TranslationInstanceManager;
public:
	/**
	 * fXgN^
	 */
	virtual ~TranslationInstance();

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return true
	 */
	virtual bool analyze(){ return analyzeInstance(); }

	//--------------------------------------------------------------------------
	/**
	 * Lampւ̕ϊ
	 * @param scene V[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene) = 0;

	/**
	 * Aj[V̕ϊ
	 * @param animationManager Aj[V}l[W
	 * @param animationSet Aj[VZbg
	 * @return true
	 */
	virtual bool convertAnimation(
		AnimationManager* animationManager, AnimationSet* animationSet) = 0;

	//--------------------------------------------------------------------------
	/**
	 * O̎擾
	 * @return O
	 */
	virtual String getName() const{ return name_; }

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * ϊV[m[hCX^Xǂ
	 * @return ϊV[m[hCX^XȂtrue
	 */
	virtual bool isTranslationSceneNodeInstance() const{ return false; }

	/**
	 * ϊV[m[hCX^Xւ̃LXg
	 * @return ϊV[m[hCX^XB^ႦNULLԂB
	 */
	virtual TranslationSceneNodeInstance* castTranslationSceneNodeInstance() const{
		if(isTranslationSceneNodeInstance()){
			return (TranslationSceneNodeInstance*)this;
		}
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * ϊCgCX^Xǂ
	 * @return ϊCgCX^XȂtrue
	 */
	virtual bool isTranslationLightInstance() const{ return false; }

	/**
	 * ϊCgCX^Xւ̃LXg
	 * @return ϊCgCX^XB^ႦNULLԂB
	 */
	virtual TranslationLightInstance* castTranslationLightInstance() const{
		if(isTranslationLightInstance()){
			return (TranslationLightInstance*)this;
		}
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * ϊfCX^Xǂ
	 * @return ϊfCX^XȂtrue
	 */
	virtual bool isTranslationModelInstance() const{ return false; }

	/**
	 * ϊfCX^Xւ̃LXg
	 * @return ϊfCX^XB^ႦNULLԂB
	 */
	virtual TranslationModelInstance* castTranslationModelInstance() const{
		if(isTranslationModelInstance()){
			return (TranslationModelInstance*)this;
		}
		return NULL;
	}

protected:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param initializePath DagpX
	 * @param initializeName 閼O
	 */
	TranslationInstance(
		const MDagPath& initializePath, const String& initializeName);

	/**
	 * CX^X̕
	 * @return true
	 */
	virtual bool analyzeInstance();

	/**
	 * V[m[hAj[V̕ϊ
	 * @param animationManager Aj[V}l[W
	 * @param animationSet Aj[VZbg
	 * @param sourceSceneNode Rs[V[m[h
	 * @param destinationSceneNode Rs[V[m[h
	 */
	virtual bool convertSceneNodeAnimation(
		AnimationManager* animationManager, AnimationSet* animationSet,
		SceneNode* sourceSceneNode, SceneNode* destinationSceneNode);

	/**
	 * V[[tAj[V̕ϊ
	 * @param animationManager Aj[V}l[W
	 * @param animationSet Aj[VZbg
	 * @param sourceSceneLeaf Rs[V[[t
	 * @param destinationSceneLeaf Rs[V[[t
	 */
	virtual bool convertSceneLeafAnimation(
		AnimationManager* animationManager, AnimationSet* animationSet,
		SceneLeaf* sourceSceneLeaf, SceneLeaf* destinationSceneLeaf);

	/// DagpX
	MDagPath dagPath_;
	/// IuWFNg
	MObject object_;
	/// O
	String name_;
	/// eV[m[h̖O
	String parentSceneNodeName_;
	/// \tO
	bool visibility_;

private:
	// Rs[RXgN^̉B
	TranslationInstance(const TranslationInstance& copy);

	// Rs[̉B
	void operator =(const TranslationInstance& copy);


};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_INSTANCE_H_
//------------------------------------------------------------------------------

