//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊCX^X
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Instance/TranslationInstance.h"
#include "Translator/Instance/TranslationInstanceManager.h"
#include "Graphics/SceneNode/SceneNodeManager.h"
#include "Animation/System/AnimationManager.h"
#include "Animation/System/AnimationSet.h"
#include "Animation/System/ObjectAnimation.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationInstance::TranslationInstance(
	const MDagPath& initializePath, const String& initializeName) :
	dagPath_(initializePath), name_(initializeName){
	MStatus result;
	// IuWFNg̎擾
	object_ = dagPath_.node(&result);
	MayaStatusCheck(result);
}
//------------------------------------------------------------------------------
// fXgN^
TranslationInstance::~TranslationInstance(){
}
//------------------------------------------------------------------------------
// CX^X̕
bool TranslationInstance::analyzeInstance(){
	MStatus result;
	MFnDagNode dagNode(dagPath_, &result);
	MayaStatusCheck(result);
	// e̖O擾
	u_int instanceNumber = dagPath_.instanceNumber(&result);
	MayaStatusCheck(result);
	MObject parent = dagNode.parent(instanceNumber, &result);
	MayaStatusCheck(result);
	parentSceneNodeName_ = MayaNodeUtility::getName(parent);
	// \tO
	visibility_ = MayaAttributeUtility::getBool(object_, "visibility");
	return true;
}
//------------------------------------------------------------------------------
// V[m[hAj[V̕ϊ
bool TranslationInstance::convertSceneNodeAnimation(
	AnimationManager* animationManager, AnimationSet* animationSet,
	SceneNode* sourceSceneNode, SceneNode* destinationSceneNode){
	Animation* source = animationManager->search(sourceSceneNode->getName());
	if((source != NULL) && (source->isObjectAnimation())){
		ObjectAnimation* destination = source->copy()->castObjectAnimation();
		Assert(destination != NULL);
		destination->setTargetName(destinationSceneNode->getName());
		animationSet->addAnimation(destination);
	}
	// q̃V[m[hǂ
	int sceneNodeCount = sourceSceneNode->getSceneNodeCount();
	for(int i = 0; i < sceneNodeCount; i++){
		convertSceneNodeAnimation(animationManager, animationSet,
			sourceSceneNode->getSceneNode(i),
			destinationSceneNode->getSceneNode(i));
	}
	// q̃fǂ
	int sceneLeafCount = sourceSceneNode->getSceneLeafCount();
	for(int i = 0; i < sceneLeafCount; i++){
		convertSceneLeafAnimation(animationManager, animationSet,
			sourceSceneNode->getSceneLeaf(i),
			destinationSceneNode->getSceneLeaf(i));
	}
	return true;
}
//------------------------------------------------------------------------------
// V[[tAj[V̕ϊ
bool TranslationInstance::convertSceneLeafAnimation(
	AnimationManager* animationManager, AnimationSet* animationSet,
	SceneLeaf* sourceSceneLeaf, SceneLeaf* destinationSceneLeaf){
	Animation* source = animationManager->search(sourceSceneLeaf->getName());
	if(source == NULL){ return true; }
	if(!source->isObjectAnimation()){ return true; }
	ObjectAnimation* destination = source->copy()->castObjectAnimation();
	Assert(destination != NULL);
	destination->setTargetName(destinationSceneLeaf->getName());
	animationSet->addAnimation(destination);
	return true;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
