//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊtHO
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Fog/TranslationFog.h"
#include "Graphics/Scene/Scene.h"
#include "Graphics/Fog/Fog.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationFog::TranslationFog(){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationFog::~TranslationFog(){
}
//------------------------------------------------------------------------------
// 
bool TranslationFog::analyze(){
	MStatus result;
	int intResult;
	double doubleResult;
	MDoubleArray doubleArray;
	// tHOLǂ
	result = MGlobal::executeCommand(MString(
		"modelEditor -q -fogging modelPanel4;"), intResult, false, false);
	MayaStatusCheck(result);
	fogEnabled_ = (intResult != 0);
	// tHOJ[
	result = MGlobal::executeCommand(MString(
		"modelEditor -q -fogColor modelPanel4;"), doubleArray, false, false);
	MayaStatusCheck(result);
	fogColor_.set((float)doubleArray[0], (float)doubleArray[1],
		(float)doubleArray[2], (float)doubleArray[3]);
	fogColor_.a = 0.f;// tHÕAt@͎gpȂ̂0ɐݒ
	// tHO[h
	result = MGlobal::executeCommand(MString(
		"modelEditor -q -fogMode modelPanel4;"), fogMode_, false, false);
	MayaStatusCheck(result);
	// tHOZx
	result = MGlobal::executeCommand(MString(
		"modelEditor -q -fogDensity modelPanel4;"), doubleResult, false, false);
	MayaStatusCheck(result);
	fogDensity_ = (float)doubleResult;
	// tHOjA
	result = MGlobal::executeCommand(MString(
		"modelEditor -q -fogStart modelPanel4;"), doubleResult, false, false);
	MayaStatusCheck(result);
	fogNear_ = (float)doubleResult;
	// tHOt@[
	result = MGlobal::executeCommand(MString(
		"modelEditor -q -fogEnd modelPanel4;"), doubleResult, false, false);
	MayaStatusCheck(result);
	fogFar_ = (float)doubleResult;
/*
	DebugOut("\nfog\n");
	DebugOut("fogEnabled %d\n", fogEnabled_);
	DebugOut("fogColor %s\n", fogColor_.toString().getBytes());
	DebugOut("fogMode %s\n", fogMode_.asChar());
	DebugOut("fogDensity %f\n", fogDensity_);
	DebugOut("fogNear %f\n", fogNear_);
	DebugOut("fogFar %f\n", fogFar_);
//*/
	return true;
}
//------------------------------------------------------------------------------
// Lampւ̕ϊ
bool TranslationFog::convertToLamp(Scene* scene){
	Fog* fog = scene->getFog();
	fog->setEnabled(fogEnabled_);
	Color4c color;
	color.set(fogColor_);
	fog->setColor(color);
	if(fogMode_ == "linear"){
		fog->setMode(Fog::modeLinear);
	}else if(fogMode_ == "exponent"){
		fog->setMode(Fog::modeExponent);
	}else if(fogMode_ == "exponent2"){
		fog->setMode(Fog::modeExponent2);
	}else{
		MayaErrorOut(String("TranslationFog::convertToLamp() "
			"m̃tHO[hݒ肳Ă܂ ") + fogMode_.asChar());
		return false;
	}
	fog->setDensity(fogDensity_);
	fog->setNear(fogNear_);
	fog->setFar(fogFar_);
	return true;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
