//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * LampgX[^wb_
 * @author Junpee
 */

#ifndef LAMP_TRANSLATOR_H_
#define LAMP_TRANSLATOR_H_

namespace Lamp{
	class Scene;
	class AnimationManager;
	class AnimationSet;
}

namespace LampForMaya{

class TranslationScene;

//------------------------------------------------------------------------------
/**
 * LampgX[^
 */
class LampTranslator{
friend class LampTextTranslator;
friend class LampBinaryTranslator;
public:
	/**
	 * o
	 * @param file t@C
	 * @param optionsString IvV
	 * @param mode t@CANZX[h
	 * @param textFlag eLXgtO
	 * @return  MStatus::kSuccess
	 */
	virtual MStatus write(const MFileObject& file,
		const MString& optionsString, MPxFileTranslator::FileAccessMode mode,
		bool textFlag);

	//--------------------------------------------------------------------------
	/**
	 * eLXgV[gq̎擾
	 * @return eLXgV[gq
	 */
	static String getTextSceneExtension(){ return "tsn"; }

	/**
	 * eLXgAj[Vgq̎擾
	 * @return eLXgAj[Vgq
	 */
	static String getTextAnimationExtension(){ return "tam"; }

	/**
	 * oCiV[gq̎擾
	 * @return oCiV[gq
	 */
	static String getBinarySceneExtension(){ return "bsn"; }

	/**
	 * oCiAj[Vgq̎擾
	 * @return oCiAj[Vgq
	 */
	static String getBinaryAnimationExtension(){ return "bam"; }

private:
	// RXgN^
	LampTranslator();

	// fXgN^
	virtual ~LampTranslator();

	// G[n
	virtual MStatus errorCleanup();

	// IvV
	virtual void analyzeOption(const String& options);

	// JnbZ[Wo
	virtual void outputStartMessage();

	// Rs[RXgN^̉B
	LampTranslator(const LampTranslator& copy);

	// Rs[̉B
	void operator =(const LampTranslator& copy);

	// ϊpV[
	TranslationScene* translationScene_;
	// V[
	Scene* scene_;
	// Aj[V}l[W
	AnimationManager* animationManager_;
	// Aj[VZbg
	AnimationSet* animationSet_;

	// eLXgo̓tO
	bool textExportFlag_;
	// V[o̓tO
	bool exportSceneFlag_;
	// sN`o̓pX
	String picturePath_;
	// bVœKtO
	bool meshOptimizeFlag_;
	// LN^XP[
	float characterScale_;
	// Aj[Vo̓tO
	bool exportAnimationFlag_;
	// ÓI`l폜tO
	bool deleteStaticChannelsFlag_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of LAMP_TRANSLATOR_H_
//------------------------------------------------------------------------------
