//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * LampoCigX[^wb_
 * @author Junpee
 */

#ifndef LAMP_BINARY_TRANSLATOR_H_
#define LAMP_BINARY_TRANSLATOR_H_

#include "Translator/Core/LampTranslator.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
/**
 * LampoCigX[^
 */
class LampBinaryTranslator : public MPxFileTranslator{
public:
	/**
	 * RXgN^
	 */
	LampBinaryTranslator(){}

	/**
	 * fXgN^
	 */
	virtual ~LampBinaryTranslator(){}

	/**
	 * 
	 *
	 * unloadPluginsȂƃ[NƂČo܂B
	 * @return vOCCX^X
	 */
	static void* creator(){ return new LampBinaryTranslator(); }

	/**
	 * o
	 * @param file t@C
	 * @param optionsString IvV
	 * @param mode t@CANZX[h
	 * @return  MStatus::kSuccess
	 */
	virtual MStatus writer(const MFileObject& file,
		const MString& optionsString, FileAccessMode mode){
		LampTranslator translator;
		return translator.write(file, optionsString, mode, false);
	}

	/**
	 * ǂݍ
	 * @param file t@C
	 * @param optionsString IvV
	 * @param mode t@CANZX[h
	 * @return  MStatus::kSuccess
	 */
	virtual MStatus reader (const MFileObject& file,
		const MString& optionsString, FileAccessMode mode){
		return MStatus(MStatus::kFailure);
	}

	/**
	 * ftHggq
	 * @return ftHggq
	 */
	virtual MString defaultExtension() const{
		return LampTranslator::getBinarySceneExtension().getBytes();
	}

	/**
	 * t@CtB^
	 * @return t@CtB^
	 */
	virtual MString filter() const{
		return MString("*.") + defaultExtension();
	}

	/**
	 * ݃\bh
	 * @return ݃\bhȂtrue
	 */
	virtual bool haveWriteMethod() const{ return true; }

	/**
	 * ǂݍ݃\bh
	 * @return ǂݍ݃\bhȂtrue
	 */
	virtual bool haveReadMethod() const{ return false; }

	/**
	 * l[Xy[XT|[g邩ǂ
	 * @return l[Xy[XT|[gȂtrue
	 */
	virtual bool haveNamespaceSupport() const{ return false; }

	/**
	 * t@CJƂł邩
	 * @return t@CJȂtrue
	 */
	virtual bool canBeOpened() const{ return false; }

	/**
	 * t@C̎
	 * @param file t@CIuWFNg
	 * @param buffer t@Cobt@
	 * @param size obt@TCY
	 * @return t@C̃t@CtH[}bgǂ
	 */
	virtual MPxFileTranslator::MFileKind identifyFile(
		const MFileObject& file, const char* buffer, short size) const{
		// SĎ̃tH[}bgłȂ
		return kNotMyFileType;
	}


private:
	// Rs[RXgN^̉B
	LampBinaryTranslator(const LampBinaryTranslator& copy);

	// Rs[̉B
	void operator =(const LampBinaryTranslator& copy);

};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of LAMP_BINARY_TRANSLATOR_H_
//------------------------------------------------------------------------------
