//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊJ}l[W
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Camera/TranslationCameraManager.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationCameraManager::TranslationCameraManager() :
	database_(256, 0.75f), array_(256){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationCameraManager::~TranslationCameraManager(){
	Assert(database_.getCount() == 0);
	Assert(array_.getCount() == 0);
	if(getCount() != 0){ clear(); }
}
//------------------------------------------------------------------------------
// J̎W
bool TranslationCameraManager::collectCameras(){
	MStatus result;
	MItDag dagIterator(MItDag::kBreadthFirst, MFn::kCamera, &result);
	MayaStatusCheck(result);
	MDagPath dagPath;
	for( ; !dagIterator.isDone(); dagIterator.next()){
		result = dagIterator.getPath(dagPath);
		MayaStatusCheck(result);
		MFnDagNode dagNode(dagPath, &result);
		MayaStatusCheck(result);
		// CX^XĂ΃LZ
		u_int instanceNumber = dagPath.instanceNumber(&result);
		MayaStatusCheck(result);
		if(instanceNumber > 0){ continue; }
		// O̎擾
		MString dagName = dagNode.name(&result);
		MayaStatusCheck(result);
		// ftHgJ͂
		if((dagName == "perspShape") ||
			(dagName == "topShape") ||
			(dagName == "frontShape") ||
			(dagName == "sideShape")){ continue; }
		// J̉
		if(!analysisCamera(dagPath)){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// J̉
bool TranslationCameraManager::analysisCamera(MDagPath dagPath){
	MStatus result;
	MFnDagNode dagNode(dagPath, &result);
	MayaStatusCheck(result);
	// Ȍd`FbN
	String cameraName = dagNode.name(&result).asChar();
	MayaStatusCheck(result);
	TranslationCamera* exist = database_.get(cameraName);
	if(exist != NULL){
		MayaErrorOut(String("TranslationCameraManager::analysisCamera() "
			"OdĂ܂ ") + cameraName);
		return false;
	}
	TranslationCamera* camera =
		new TranslationCamera(dagPath, cameraName);
	if(!camera->analyze()){
		delete camera;
		return false;
	}
	database_.put(cameraName, camera);
	array_.add(camera);
	return true;
}
//------------------------------------------------------------------------------
// Aj[V̎W
bool TranslationCameraManager::collectAnimations(){
	for(int i = 0; i < getCount(); i++){
		if(!get(i)->analyzeAnimation()){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// Lampւ̕ϊ
bool TranslationCameraManager::convertToLamp(Scene* scene) const{
	// J̃Ro[g
	for(int i = 0; i < getCount(); i++){
		if(!get(i)->convertToLamp(scene)){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// Aj[V̕ϊ
bool TranslationCameraManager::convertAnimation(
	AnimationManager* animationManager, AnimationSet* animationSet){
	for(int i = 0; i < getCount(); i++){
		if(!get(i)->convertAnimation(animationManager, animationSet)){
			return false;
		}
	}
	return true;
}
//------------------------------------------------------------------------------
// NA
int TranslationCameraManager::clear(){
	int result = getCount();
	// vf̍폜
	for(int i = 0; i < result; i++){ delete array_.get(i); }
	array_.clear();
	database_.clear();
	return result;
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
