//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊJwb_
 * @author Junpee
 */

#ifndef TRANSLATION_CAMERA_H_
#define TRANSLATION_CAMERA_H_

namespace Lamp{
	class Scene;
	class Camera;
	class AnimationManager;
	class AnimationSet;
	class VectorArrayInterpolator;
	class EulerArrayInterpolator;
}

#include "Translator/Animation/TranslationSequence.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
/**
 * ϊJ
 */
class TranslationCamera{
friend class TranslationCameraManager;
public:
	/**
	 * fXgN^
	 */
	virtual ~TranslationCamera();

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return true
	 */
	virtual bool analyze();

	/**
	 * Aj[V̕
	 * @return true
	 */
	virtual bool analyzeAnimation();

	//--------------------------------------------------------------------------
	/**
	 * Lampւ̕ϊ
	 * @param scene V[
	 * @return true
	 */
	virtual bool convertToLamp(Scene* scene);

	/**
	 * Aj[V̕ϊ
	 * @param animationManager Aj[V}l[W
	 * @param animationSet Aj[VZbg
	 * @return true
	 */
	virtual bool convertAnimation(
		AnimationManager* animationManager, AnimationSet* animationSet);

	//--------------------------------------------------------------------------
	/**
	 * IuWFNg̎擾
	 * @return IuWFNg
	 */
	virtual MObject getObject() const{ return object_; }

	/**
	 * O̎擾
	 * @return O
	 */
	virtual String getName() const{ return name_; }

protected:
	/**
	 * RXgN^
	 * @param initializePath DagpX
	 * @param initializeName 閼O
	 */
	TranslationCamera(
		const MDagPath& initializePath,const String& initializeName);

	/**
	 * [`FbN
	 * @param point `FbN|Cg
	 * @return |Cg0ȂtrueԂ
	 */
	virtual bool zeroCheck(const MPoint& point);

	/// DagpX
	MDagPath dagPath_;
	/// IuWFNg
	MObject object_;
	/// O
	String name_;
	/// J
	Camera* camera_;

	/// ]
	Vector3 rotation_;
	/// ړ
	Vector3 translation_;

	/// V[PX
	TranslationSequence sequence_;
	/// ]Aj[V
	EulerArrayInterpolator* rotationAnimation_;
	/// ړAj[V
	VectorArrayInterpolator* translationAnimation_;
	/// Aj[V
	bool hasAnimation_;

private:
	// Rs[RXgN^̉B
	TranslationCamera(const TranslationCamera& copy);

	// Rs[̉B
	void operator =(const TranslationCamera& copy);


};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_CAMERA_H_
//------------------------------------------------------------------------------

