//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊV[PXwb_
 * @author Junpee
 */

#ifndef TRANSLATION_SEQUENCE_H_
#define TRANSLATION_SEQUENCE_H_

namespace LampForMaya{

//------------------------------------------------------------------------------
/**
 * ϊV[PX
 */
class TranslationSequence{
public:
	/**
	 * RXgN^
	 */
	TranslationSequence();

	/**
	 * fXgN^
	 */
	virtual ~TranslationSequence();

	/**
	 * 
	 * @param object ͂IuWFNg
	 * @return V[PXtrue
	 */
	virtual bool analyze(const MObject& object);

	/**
	 * V[PX
	 * @return V[PXȂtrue
	 */
	virtual bool hasSequence() const{ return hasSequence_; }

	/**
	 * V[PX̎擾
	 * @return V[PX
	 */
	virtual int getSequenceCount() const{ return sequenceCount_; }

	/**
	 * JnԂ̎擾
	 * @param sequence V[PX
	 * @return Jn
	 */
	virtual int getStartTime(int sequence){
		Assert(startTime_ != NULL);
		Assert(sequence >= 0);
		Assert(sequence < sequenceCount_);
		return startTime_[sequence];
	}

	/**
	 * IԂ̎擾
	 * @param sequence V[PX
	 * @return I
	 */
	virtual int getEndTime(int sequence){
		Assert(endTime_ != NULL);
		Assert(sequence >= 0);
		Assert(sequence < sequenceCount_);
		return endTime_[sequence];
	}

	/**
	 * [v̎擾
	 * @param sequence V[PX
	 * @return [v
	 */
	virtual bool isLooped(int sequence){
		Assert(looped_ != NULL);
		Assert(sequence >= 0);
		Assert(sequence < sequenceCount_);
		return looped_[sequence];
	}

private:
	// Rs[RXgN^̉B
	TranslationSequence(const TranslationSequence& copy);

	// Rs[̉B
	void operator =(const TranslationSequence& copy);

	// V[PX
	int sequenceCount_;
	// Jn
	int* startTime_;
	// I
	int* endTime_;
	// [v
	bool* looped_;
	// V[PX
	bool hasSequence_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of TRANSLATION_SEQUENCE_H_
//------------------------------------------------------------------------------

