//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊV[PX
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Animation/TranslationSequence.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// RXgN^
TranslationSequence::TranslationSequence() :
	hasSequence_(false), sequenceCount_(0),
	startTime_(NULL), endTime_(NULL), looped_(NULL){
}
//------------------------------------------------------------------------------
// fXgN^
TranslationSequence::~TranslationSequence(){
	SafeArrayDelete(startTime_);
	SafeArrayDelete(endTime_);
	SafeArrayDelete(looped_);
}
//------------------------------------------------------------------------------
// 
bool TranslationSequence::analyze(const MObject& object){
	hasSequence_ = false;
	String errorString;
	MStatus result;
	MFnDependencyNode dependencyNode(object, &result);
	MayaStatusCheck(result);
	MString name = dependencyNode.name(&result);
	MayaStatusCheck(result);
	// V[PXAgr[g݂邩
	MString sequenceName("LampSequence");
	MObject attribute = dependencyNode.attribute(sequenceName, &result);
	if(!result){ return hasSequence_; }
	// V[PXAgr[gAj[VĂ邩
	MPlug attributePlug = dependencyNode.findPlug(sequenceName, &result);
	MayaStatusCheck(result);
	if(!MAnimUtil::isAnimated(attributePlug)){
//		MayaErrorOut(MString("TranslationSequence::analyze() ") + sequenceName +
//			"Agr[gL܂AAj[VĂ܂ " + name);
		return hasSequence_;
	}
	// Aj[VJ[u̎擾
	MPlugArray plugArray;
	if(!attributePlug.connectedTo(plugArray, true, false, &result)){
		MayaErrorOut(MString("TranslationSequence::analyze() ") + sequenceName +
			"Agr[gL܂AAj[VĂ܂ " + name);
		return hasSequence_;
	}
	MayaStatusCheck(result);
	if(plugArray.length() != 1){
		MayaErrorOut(MString("TranslationSequence::analyze() ") + sequenceName +
			"Agr[gL܂ÃvOڑĂ܂ " + name);
		return hasSequence_;
	}
	MObject curveObject = plugArray[0].node(&result);
	MayaStatusCheck(result);
	MFnAnimCurve curve(curveObject, &result);
	MayaStatusCheck(result);
	// Aj[VL[1ȏ゠邩
	u_int keyCount = curve.numKeys(&result);
	MayaStatusCheck(result);
	if(keyCount == 0){
		MayaErrorOut(MString("TranslationSequence::analyze() ") + sequenceName +
			"Agr[gL܂AL[܂ " + name);
		return hasSequence_;
	}
	// L[̊Ԋu`FbN
	double preTime = 0.f;
	for(u_int i = 0; i < keyCount; i++){
		double time = curve.time(i, &result).value();
		MayaStatusCheck(result);
		if(time - preTime < 2.0){
			MayaErrorOut(MString("TranslationSequence::analyze() "
				"V[PX̃Aj[VL[͎Ԃ̊Ԋu2ȏKvł ") +
				name);
			return hasSequence_;
		}
		preTime = time;
	}
	// L[̃G[`FbN
	for(u_int i = 0; i < keyCount; i++){
		// Ԃ-̃L[`FbN
		double time = curve.time(i, &result).value();
		MayaStatusCheck(result);
		if(time < 0.0){
			MayaErrorOut(MString("TranslationSequence::analyze() "
				"V[PX̃Aj[VL[+̎Ԃݒ肵Ă ") +
				name + " " + time);
			return hasSequence_;
		}
		// [`FbN
//		double integer;
//		double fraction = ::modf(time, &integer);
//		if(fraction > (double)Math::epsilon){
//			MayaErrorOut(MString("TranslationSequence::analyze() "
//				"V[PX̃Aj[VL[͐Ԃݒ肵Ă ") +
//				name + " " + time);
//			return hasSequence_;
//		}
	}
	// V[PXf[^쐬
	sequenceCount_ = keyCount;
	SafeArrayDelete(startTime_);
	SafeArrayDelete(endTime_);
	SafeArrayDelete(looped_);
	startTime_ = new int[sequenceCount_];
	endTime_ = new int[sequenceCount_];
	looped_ = new bool[sequenceCount_];
	MTime time;
	double value;
	// 1ԖڃV[PX쐬
	startTime_[0] = 0;
	time = curve.time(0, &result);
	MayaStatusCheck(result);
	endTime_[0] = (int)time.value();
	MayaStatusCheck(curve.evaluate(time, value));
	looped_[0] = (value > 0.5);
	// 2Ԗڈȍ~̃V[PX쐬
	for(int i = 1; i < sequenceCount_; i++){
		startTime_[i] = (int)curve.time((i - 1), &result).value() + 1;
		MayaStatusCheck(result);
		time = curve.time(i, &result);
		MayaStatusCheck(result);
		endTime_[i] = ((int)time.value());
		MayaStatusCheck(curve.evaluate(time, value));
		looped_[i] = (value > 0.5);
	}
/*
	for(int i = 0; i < sequenceCount_; i++){
		MTime time = curve.time(i, &result);
		startTime_[i] = (int)time.value();
		MayaStatusCheck(result);
		endTime_[i] = ((int)curve.time(i + 1, &result).value()) - 1;
		MayaStatusCheck(result);
		double value;
		result = curve.evaluate(time, value);
		looped_[i] = (value > 0.5);
	}
*/
	hasSequence_ = true;
	return hasSequence_;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
