//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊAj[V[eBeBwb_
 * @author Junpee
 */

#ifndef TRANSLATION_ANIMATION_UTILITY_H_
#define TRANSLATION_ANIMATION_UTILITY_H_

namespace Lamp{
	class VectorArrayInterpolator;
	class EulerArrayInterpolator;
}

namespace LampForMaya{

//------------------------------------------------------------------------------
/**
 * ϊAj[V[eBeB
 */
class TranslationAnimationUtility{
public:
	//--------------------------------------------------------------------------
	/**
	 * xNgAj[V̕
	 * @param object Aj[VIuWFNg
	 * @param attributeName xNgAj[VAgr[g
	 * @param defaultValue ftHgl
	 * @param startTime Jn
	 * @param endTime I
	 * @return xNgAj[VBĂяodeleteKvB
	 */
	static VectorArrayInterpolator* analyzeVectorAnimation(
		const MObject& object, const MString& attributeName,
		const Vector3& defaultValue, int startTime, int endTime);

	//--------------------------------------------------------------------------
	/**
	 * ]Aj[V̕
	 * @param object Aj[VIuWFNg
	 * @param attributeName xNgAj[VAgr[g
	 * @param defaultValue ftHgl
	 * @param startTime Jn
	 * @param endTime I
	 * @return ]Aj[VBĂяodeleteKvB
	 */
	static EulerArrayInterpolator* analyzeRotationAnimation(
		const MObject& object, const MString& attributeName,
		const Vector3& defaultValue, int startTime, int endTime);

protected:
	/**
	 * Aj[VĂ邩
	 * @param plug Aj[VĂ邩ׂvO
	 * @param startTime Jn
	 * @param endTime I
	 * @return Aj[VĂtrue
	 */
//	static bool isAnimated(const MPlug& plug, int startTime, int endTime);

private:
	// RXgN^̉B
	TranslationAnimationUtility();

	// fXgN^̉B
	virtual ~TranslationAnimationUtility();

};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of TRANSLATION_ANIMATION_UTILITY_H_
//------------------------------------------------------------------------------

