//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ϊAj[V[eBeB
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Translator/Animation/TranslationAnimationUtility.h"
#include "Animation/VectorInterpolator/VectorArrayInterpolator.h"
#include "Animation/RotationInterpolator/EulerArrayInterpolator.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// xNgAj[V̕
VectorArrayInterpolator* TranslationAnimationUtility::analyzeVectorAnimation(
	const MObject& object, const MString& attributeName,
	const Vector3& defaultValue, int startTime, int endTime){
	MStatus result;
	MFnDependencyNode dependencyNode(object, &result);
	MayaStatusCheck(result);
	// Aj[VĂ邩ǂ
	MPlug xPlug = dependencyNode.findPlug(attributeName + "X", &result);
	MayaStatusCheck(result);
//	bool xAnimated = isAnimated(xPlug, startTime, endTime);
	MPlug yPlug = dependencyNode.findPlug(attributeName + "Y", &result);
	MayaStatusCheck(result);
//	bool yAnimated = isAnimated(yPlug, startTime, endTime);
	MPlug zPlug = dependencyNode.findPlug(attributeName + "Z", &result);
	MayaStatusCheck(result);
//	bool zAnimated = isAnimated(zPlug, startTime, endTime);
//	if((!xAnimated) && (!yAnimated) && (!zAnimated)){ return NULL; }
	// Aj[Vf[^̓ǂݏo
	VectorArrayInterpolator* interpolator =
		new VectorArrayInterpolator();
	int size = endTime - startTime + 1;
	interpolator->setSize(endTime - startTime + 1);
	for(int i = 0; i < size; i++){
		Vector3 value(defaultValue);
		MDGContext context(MTime((double)(startTime + i)));
//		if(xAnimated){ xPlug.getValue(value.x, context); }
//		if(yAnimated){ yPlug.getValue(value.y, context); }
//		if(zAnimated){ zPlug.getValue(value.z, context); }
		xPlug.getValue(value.x, context);
		yPlug.getValue(value.y, context);
		zPlug.getValue(value.z, context);
		interpolator->setValue(startTime + i, value);
	}
	return interpolator;
}
//------------------------------------------------------------------------------
// ]Aj[V̕
EulerArrayInterpolator*
	TranslationAnimationUtility::analyzeRotationAnimation(
	const MObject& object, const MString& attributeName,
	const Vector3& defaultValue, int startTime, int endTime){
	MStatus result;
	MFnDependencyNode dependencyNode(object, &result);
	MayaStatusCheck(result);
	// Aj[VĂ邩ǂ
	MPlug xPlug = dependencyNode.findPlug(attributeName + "X", &result);
	MayaStatusCheck(result);
//	bool xAnimated = isAnimated(xPlug, startTime, endTime);
	MPlug yPlug = dependencyNode.findPlug(attributeName + "Y", &result);
	MayaStatusCheck(result);
//	bool yAnimated = isAnimated(yPlug, startTime, endTime);
	MPlug zPlug = dependencyNode.findPlug(attributeName + "Z", &result);
	MayaStatusCheck(result);
//	bool zAnimated = isAnimated(zPlug, startTime, endTime);
//	if((!xAnimated) && (!yAnimated) && (!zAnimated)){ return NULL; }
	// Aj[Vf[^̓ǂݏo
	EulerArrayInterpolator* interpolator =
		new EulerArrayInterpolator();
	int size = endTime - startTime + 1;
	interpolator->setSize(endTime - startTime + 1);
	for(int i = 0; i < size; i++){
		Vector3 value(defaultValue);
		MDGContext context(MTime((double)(startTime + i)));
//		if(xAnimated){ xPlug.getValue(value.x, context); }
//		if(yAnimated){ yPlug.getValue(value.y, context); }
//		if(zAnimated){ zPlug.getValue(value.z, context); }
		xPlug.getValue(value.x, context);
		yPlug.getValue(value.y, context);
		zPlug.getValue(value.z, context);
		interpolator->setValue(startTime + i, value);
	}
	return interpolator;
}
//------------------------------------------------------------------------------
// Aj[VĂ邩
/*
bool TranslationAnimationUtility::isAnimated(
	const MPlug& plug, int startTime, int endTime){
	MStatus result;
	bool animated = MAnimUtil::isAnimated(plug, true, &result);
	MayaStatusCheck(result);
	// Aj[VtOĂtrue
	if(animated){ return true; }
	// Aj[VtOĂȂĂlɕωtrue
	int size = endTime - startTime + 1;
	float startValue;
	MDGContext startContext(MTime((double)(startTime)));
	plug.getValue(startValue, startContext);
	for(int i = 0; i < size; i++){
		MDGContext context(MTime((double)(startTime + i)));
		float value;
		plug.getValue(value, context);
		if(Math::abs(startValue - value) > Math::epsilon){ return true; }
	}
	return false;
}
*/
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
