//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * MayaeNX`}l[Wwb_
 * @author Junpee
 */

#ifndef MAYA_TEXTURE_MANAGER_H_
#define MAYA_TEXTURE_MANAGER_H_

#include <Core/Container/HashMap.h>
#include <Core/Container/ArrayList.h>

namespace LampForMaya{

class MayaTexture;

//------------------------------------------------------------------------------
/**
 * MayaeNX`}l[W
 */
class MayaTextureManager{
public:
	//--------------------------------------------------------------------------
	/**
	 * QƂ̒ǉ
	 */
	static void addReference();

	/**
	 * QƂ̍폜
	 */
	static void removeReference();

	//--------------------------------------------------------------------------
	/**
	 * oCh
	 * @param textureNode eNX`m[h
	 * @return true
	 */
	static bool bind(const MObject& textureNode);

	//--------------------------------------------------------------------------
	/**
	 * OύXR[obN
	 * @param node OύXꂽm[h
	 * @param data f[^
	 */
	static void renameCallback(MObject& node, void* data);

	/**
	 * R[obN
	 * @param data f[^
	 */
	static void dirtyCallback(void* data);

protected:
	//--------------------------------------------------------------------------
	/**
	 * 
	 */
	static void initialize();

	/**
	 * n
	 */
	static void finalize();

	/**
	 * f[^x[Xɒǉ
	 * @param texture eNX`
	 */
	static void addDatabase(MayaTexture* texture);

	/**
	 * f[^x[X폜
	 * @param texture eNX`
	 */
	static void removeDatabase(MayaTexture* texture);

	/**
	 * f[^x[X̃NA
	 */
	static void clearDatabase();

private:
	// RXgN^̉B
	MayaTextureManager();

	// f[^x[X
	static HashMap<String, MayaTexture*>* database_;
	// z
	static ArrayList<MayaTexture*>* array_;
	// t@XJEg
	static int referenceCount_;

};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of MAYA_TEXTURE_MANAGER_H_
//------------------------------------------------------------------------------

