//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * MayaeNX`wb_
 * @author Junpee
 */

#ifndef MAYA_TEXTURE_H_
#define MAYA_TEXTURE_H_

namespace LampForMaya{

//------------------------------------------------------------------------------
/**
 * MayaeNX`
 */
class MayaTexture{
friend class MayaTextureManager;
public:
	/**
	 * eNX`̃[h
	 * @return true
	 */
	virtual bool load();

	/**
	 * eNX`̃oCh
	 * @return true
	 */
	virtual bool bind();

	/**
	 * O̎擾
	 * @return O
	 */
	virtual const String& getName() const{ return name_; }

	/**
	 * ̎擾
	 * @param level ~bv}bvx
	 * @return 
	 */
	virtual u_int getWidth(int level = 0) const{
		u_int width = width_ >> level;
		if(width > 0){ return width; }
		return 1;
	}

	/**
	 * ̎擾
	 * @param level ~bv}bvx
	 * @return 
	 */
	virtual u_int getHeight(int level = 0) const{
		u_int height = height_ >> level;
		if(height > 0){ return height; }
		return 1;
	}

protected:
	/**
	 * RXgN^
	 * @param node m[h
	 * @param name O
	 */
	MayaTexture(const MObject& node, const String& name);

	/**
	 * fXgN^
	 */
	virtual ~MayaTexture();

	/**
	 * NA
	 */
	virtual void clear();

	/**
	 * ő2̗ݏ߂
	 * @param number ΏۂƂȂ鐔
	 * @return Ώۂ̐ȉɂő2̗ݏ
	 */
	u_int highestPowerOf2(u_int number) const{
		int power = 0;
		while(number > 1){
			power++;
			number >>= 1;
		}
		return power;
	}

private:
	// Rs[RXgN^̉B
	MayaTexture(const MayaTexture& copy);

	// Rs[̉B
	void operator =(const MayaTexture& copy);

	// m[h
	MObject node_;
	// O
	String name_;
	// eNX`ID
	u_int textureID_;
	// C[W
	u_char** images_;
	// ~bv}bvx
	int mipmapLevel_;
	// 
	u_int width_;
	// 
	u_int height_;
	// l[R[obNID
	MCallbackId renameCallbackID_;
	// ύXR[obNID
	MCallbackId dirtyCallbackID_;
	// [hς݃tO
	bool loaded_;

	// sNZoCg
	static const int bytesPerPixel_ = 4;
};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of MAYA_TEXTURE_H_
//------------------------------------------------------------------------------

