//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * MayaG[o̓wb_
 * @author Junpee
 */

#ifndef MAYA_ERROR_H_
#define MAYA_ERROR_H_

/**
 * MayabZ[Wo
 * @param mayaMessage bZ[W
 */
#define MayaMessageOut(mayaMessage) \
	(MayaErrorOutput::mayaMessageOutput(mayaMessage))

/**
 * MayaG[o
 * @param mayaErrorMessage G[bZ[W
 */
#define MayaErrorOut(mayaErrorMessage) \
	(MayaErrorOutput::mayaErrorOutput((mayaErrorMessage), __FILE__, __LINE__))

/**
 * MayaXe[^X`FbN
 * @param mayaStatusCheck `FbNXe[^X
 * @return Xe[^XȂtrue
 */
#define MayaStatusCheck(mayaStatusCheck) \
	(MayaErrorOutput::mayaErrorCheck(\
		MStatus(mayaStatusCheck), __FILE__, __LINE__))

/**
 * MayaOpenGLG[`FbN
 * @return Xe[^XȂtrue
 */
#define MayaOpenGLCheck() \
	(MayaErrorOutput::mayaOpenGLErrorCheck(__FILE__, __LINE__))

namespace LampForMaya{

//------------------------------------------------------------------------------
/**
 * MayaG[o
 */
class MayaErrorOutput{
public:
	/**
	 * 
	 */
	static void initialize();

	/**
	 * bZ[Wo
	 * @param message bZ[W
	 */
	static void mayaMessageOutput(const char* message);

	/**
	 * bZ[Wo
	 * @param message bZ[W
	 */
	static void mayaMessageOutput(const String& message);

	/**
	 * bZ[Wo
	 * @param message bZ[W
	 */
	static void mayaMessageOutput(const MString& message);

	/**
	 * G[o
	 * @param message G[bZ[W
	 * @param fileName t@C
	 * @param lineNumber Cԍ
	 */
	static void mayaErrorOutput(
		const char* message, const char* fileName, int lineNumber);

	/**
	 * G[o
	 * @param message G[bZ[W
	 * @param fileName t@C
	 * @param lineNumber Cԍ
	 */
	static void mayaErrorOutput(
		const String& message, const char* fileName, int lineNumber);

	/**
	 * G[o
	 * @param message G[bZ[W
	 * @param fileName t@C
	 * @param lineNumber Cԍ
	 */
	static void mayaErrorOutput(
		const MString& message, const char* fileName, int lineNumber);

	/**
	 * G[`FbN
	 * @param status Xe[^X
	 * @param fileName t@C
	 * @param lineNumber Cԍ
	 * @return G[łȂtrue
	 */
	static bool mayaErrorCheck(
		const MStatus& status, const char* fileName, int lineNumber);

	/**
	 * OpenGLG[`FbN
	 * @param fileName t@C
	 * @param lineNumber Cԍ
	 * @return G[łȂtrue
	 */
	static bool mayaOpenGLErrorCheck(const char* fileName, int lineNumber);
	 
	/**
	 * MayapG[nh
	 * @param message G[bZ[W
	 */
	static void errorHandler(const char* message);

private:
	// RXgN^̉B
	MayaErrorOutput();

};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of MAYA_ERROR_H_
//------------------------------------------------------------------------------
