//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * MayaG[o͎
 * @author Junpee
 */

#include "System/stdafx.h"
#include "System/MayaErrorOutput.h"
#include "Core/System/StringMethod.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// 
void MayaErrorOutput::initialize(){
	// G[nhύX
	ErrorOutput::setErrorHandler(MayaErrorOutput::errorHandler);
}
//------------------------------------------------------------------------------
// bZ[Wo
void MayaErrorOutput::mayaMessageOutput(const char* message){
	MString messageString(message);
	MGlobal::displayInfo(messageString);
	StdOutputDebugString(messageString.asChar());
}
//------------------------------------------------------------------------------
// bZ[Wo
void MayaErrorOutput::mayaMessageOutput(const String& message){
	MString messageString(message.getBytes());
	MGlobal::displayInfo(messageString);
	StdOutputDebugString(messageString.asChar());
}
//------------------------------------------------------------------------------
// bZ[Wo
void MayaErrorOutput::mayaMessageOutput(const MString& message){
	MGlobal::displayInfo(message);
	StdOutputDebugString(message.asChar());
}
//------------------------------------------------------------------------------
// G[o
void MayaErrorOutput::mayaErrorOutput(
	const char* message, const char* fileName, int lineNumber){
	String errorString;
	errorString.format("%s\n%s %d\n", message, fileName, lineNumber);
	ErrorOut(errorString);
}
//------------------------------------------------------------------------------
// G[o
void MayaErrorOutput::mayaErrorOutput(
	const String& message, const char* fileName, int lineNumber){
	String errorString;
	errorString.format("%s\n%s %d\n",
		message.getBytes(), fileName, lineNumber);
	ErrorOut(errorString);
}
//------------------------------------------------------------------------------
// G[o
void MayaErrorOutput::mayaErrorOutput(
	const MString& message, const char* fileName, int lineNumber){
	String errorString;
	errorString.format("%s\n%s %d\n",
		message.asChar(), fileName, lineNumber);
	ErrorOut(errorString);
}
//------------------------------------------------------------------------------
// G[`FbN
bool MayaErrorOutput::mayaErrorCheck(
	const MStatus& status, const char* fileName, int lineNumber){
	if(!status){
		String errorString;
		errorString.format("%s\n%s %d\n",
			status.errorString().asChar(), fileName, lineNumber);
		ErrorOut(errorString);
		return false;
	}
	return true;
}
//------------------------------------------------------------------------------
// OpenGLG[`FbN
bool MayaErrorOutput::mayaOpenGLErrorCheck(
	const char* fileName, int lineNumber){
	GLenum mayaOpenGLErrorCode = glGetError();
	if(mayaOpenGLErrorCode != GL_NO_ERROR){
		String errorString;
		errorString.format("%s\n%s %d\n",
			(const char*)gluErrorString(mayaOpenGLErrorCode),
			fileName, lineNumber);
		ErrorOut(errorString);
		return false;
	}
	return true;
}
//------------------------------------------------------------------------------
// MayapG[nh
void MayaErrorOutput::errorHandler(const char* message){
	MString errorString(message);
	MGlobal::displayError(errorString);
	StdOutputDebugString(errorString.asChar());
#ifdef _DEBUG
	// MayaP̂ŋNĂꍇɃu[NƁAMayaI܂B
	_asm{ int 3 }
#endif
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
