//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Lamp for Maya 
 *
 * "Test/LampForMayaUnitTestBuildFlag.h"LAMP_FOR_MAYA_UNIT_TEST_BUILD_FLAG
 * tO𗧂ĂƃjbgeXgrh܂B<br>
 * sMayaňȉ̃R}hsƃjbgeXgJn܂B<br>
 * uLampForMayaTest; unloadPlugin LampForMaya;v<br>
 * vOC̃A[h̓[N딻肵Ȃ߂ɕKvłB<br>
 * <br>
 * vWFNgݒ<br>
 * \vpeB->fobO->->R}hɁumaya.exev<br>
 * \vpeB->fobO->->R}h<br>
 * u-command "LampForMayaTestInitialize;"v<br>
 * <br>
 * Mayãt@CpX<br>
 * uLamp/LampForMaya/plug-insvɃvOCpXʂKvB<br>
 * uLamp/LampForMaya/scriptsvɃXNvgpXʂKvB<br>
 * uLamp/LampForMaya/iconsvɃACRpXʂKvB<br>
 * Maya.envɈȉ̎OstƂ悢B<br>
 *  MAYA_PLUG_IN_PATH = D:/Lamp/LampForMaya/plug-ins<br>
 *  MAYA_SCRIPT_PATH = D:/Lamp/LampForMaya/scripts<br>
 *  XBMLANGPATH = D:/Lamp/LampForMaya/icons<br>
 * @author Junpee
 */

/** @namespace LampForMaya LamppMayavOC
 *
 * 3DOtBbNXCuLampMayavOCpl[Xy[XłB
 */

#include "System/stdafx.h"
#include <maya/MFnPlugin.h>
#include "Translator/Core/LampTextTranslator.h"
#include "Translator/Core/LampBinaryTranslator.h"
#include "Material/Basic/LampBasicMaterial.h"

#include "Test/LampForMayaUnitTestBuildFlag.h"
#if LAMP_FOR_MAYA_UNIT_TEST_BUILD_FLAG
#include "Test/LampForMayaTest.h"
#endif

using namespace LampForMaya;

//------------------------------------------------------------------------------
/**
 * vOC
 * @param object vOCIuWFNg
 * @return vOC̏ɐMStatus::kSuccess
 */
MStatus initializePlugin(MObject object){
	//--------------------------------------------------------------------------
	// VXe
	//--------------------------------------------------------------------------
	// Lamp
	LampCore::initialize();
	// MayaG[o͏
	MayaErrorOutput::initialize();

	//--------------------------------------------------------------------------
	MStatus result;

	MFnPlugin plugin(object, "Nemunekoya", "0.1", "Any");

	// T[tF[XVF[_
	MString surfaceShaderClassify("shader/surface");

	// {}eA̓o^
	result = plugin.registerNode(
		"LampBasicMaterial",			// vOC
		LampBasicMaterial::id,			// ^CvID
		LampBasicMaterial::creator,		// \bh
		LampBasicMaterial::initialize,	// \bh
		MPxNode::kHwShaderNode,			// m[h̎ނw
		&surfaceShaderClassify);		// VF[_
	MayaStatusCheck(result);

	// eLXgt@Co̓vOC̓o^
	result = plugin.registerFileTranslator(
		"LampTextTranslator",			// vOC
		"LampTextTranslator.xpm",		// ACRt@C
		LampTextTranslator::creator,	// \bh
		"LampTranslatorOptions",		// IvVMELXNvg
		"",								// ftHgIvV
		true);							// MELgptO
	MayaStatusCheck(result);

	// oCit@Co̓vOC̓o^
	result = plugin.registerFileTranslator(
		"LampBinaryTranslator",			// vOC
		"LampBinaryTranslator.xpm",		// ACRt@C
		LampBinaryTranslator::creator,	// \bh
		"LampTranslatorOptions",		// IvVMELXNvg
		"",								// ftHgIvV
		true);							// MELgptO
	MayaStatusCheck(result);

#if LAMP_FOR_MAYA_UNIT_TEST_BUILD_FLAG
	// eXgR}hvOC̓o^
	result = plugin.registerCommand(
		"LampForMayaTest", LampForMayaTest::creator);
	MayaStatusCheck(result);
#endif

	return result;
}
//------------------------------------------------------------------------------
/**
 * vOCn
 * @param object vOCIuWFNg
 * @return vOČnɐMStatus::kSuccess
 */
MStatus uninitializePlugin(MObject object){
	MStatus result;
	MFnPlugin plugin(object);

#if LAMP_FOR_MAYA_UNIT_TEST_BUILD_FLAG
	// eXgR}hvOC̓o^
	result = plugin.deregisterCommand ("LampForMayaTest");
	MayaStatusCheck(result);
#endif

	// oCit@Co̓vOC̓o^
	result = plugin.deregisterFileTranslator("LampBinaryTranslator");
	MayaStatusCheck(result);

	// eLXgt@Co̓vOC̓o^
	result = plugin.deregisterFileTranslator("LampTextTranslator");
	MayaStatusCheck(result);

	// {}eA̓o^
	result = plugin.deregisterNode(LampBasicMaterial::id);
	MayaStatusCheck(result);

	// Lampn
	LampCore::finalize();

	//--------------------------------------------------------------------------
	return result;
}
//------------------------------------------------------------------------------
