//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Lamp}eA[eBeBwb_
 * @author Junpee
 */

#ifndef LAMP_MATERIAL_UTILITY_H_
#define LAMP_MATERIAL_UTILITY_H_

namespace LampForMaya{

//------------------------------------------------------------------------------
/**
 * Lamp}eA[eBeB
 */
class LampMaterialUtility{
public:
	//--------------------------------------------------------------------------
	// eNX`
	//--------------------------------------------------------------------------
	/**
	 * eNX`̎擾
	 * @param node Agr[gm[h
	 * @param attributeName eNX`Agr[g
	 * @return eNX`
	 */
	static MObject getTexture(
		const MObject& node, const String& attributeName);

	/**
	 * eNX`̎擾
	 * @param node Agr[gm[h
	 * @param attributeName eNX`Agr[g
	 * @return eNX`
	 */
	static String getTextureName(
		const MObject& node, const String& attributeName);

	//--------------------------------------------------------------------------
	// Agr[g
	//--------------------------------------------------------------------------
	/**
	 * x[XeNX`Agr[g̒ǉ
	 */
	static void addBaseTextureAttribute();

	/**
	 * eNX`Agr[g̒ǉ
	 */
	static void addGlossTextureAttribute();

	/**
	 * CgeNX`Agr[g̒ǉ
	 */
	static void addLightTextureAttribute();

	/**
	 * eNX`Agr[g̒ǉ
	 */
	static void addStainTextureAttribute();

	/**
	 * fBt[YAgr[g̒ǉ
	 */
	static void addDiffuseAttribute();

	/**
	 * XyLAgr[g̒ǉ
	 */
	static void addSpecularAttribute();

	/**
	 * ArGgAgr[g̒ǉ
	 */
	static void addAmbientAttribute();

	/**
	 * G~bVuAgr[g̒ǉ
	 */
	static void addEmissiveAttribute();

private:
	/**
	 * RXgN^
	 */
	LampMaterialUtility();

};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of LAMP_MATERIAL_UTILITY_H_
//------------------------------------------------------------------------------

