//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Lamp}eA[eBeB
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Material/Utility/LampMaterialUtility.h"

namespace LampForMaya{

//------------------------------------------------------------------------------
// eNX`
//------------------------------------------------------------------------------
// eNX`̎擾
MObject LampMaterialUtility::getTexture(
	const MObject& node, const String& attributeName){
	MStatus result;
	MPlug texturePlug = MayaAttributeUtility::getPlug(node, attributeName);
	MItDependencyGraph textureIterator(
		texturePlug, MFn::kFileTexture,
		MItDependencyGraph::kUpstream,
		MItDependencyGraph::kBreadthFirst,
		MItDependencyGraph::kNodeLevel);
	MObject texture = textureIterator.thisNode();
	if(texture.hasFn(MFn::kFileTexture)){
		return texture;
	}
	return MObject();
}
//------------------------------------------------------------------------------
// eNX`̎擾
String LampMaterialUtility::getTextureName(
	const MObject& node, const String& attributeName){
	MObject texture = getTexture(node, attributeName);
	if(texture.isNull()){ return String(""); }
	String textureName = MayaNodeUtility::getName(texture);
	return textureName;
}
//------------------------------------------------------------------------------
// Agr[g
//------------------------------------------------------------------------------
// x[XeNX`Agr[g̒ǉ
void LampMaterialUtility::addBaseTextureAttribute(){
	MStatus result;
	MFnNumericAttribute attribute;
	// x[XeNX`
	MObject baseTexture = attribute.createColor(
		"color", "c", &result);
	MayaStatusCheck(result);
	MayaStatusCheck(attribute.setDefault(1.f, 1.f, 1.f));
	MayaStatusCheck(MPxNode::addAttribute(baseTexture));
	MayaStatusCheck(MPxNode::attributeAffects(
		baseTexture, MPxHwShaderNode::outColor));
	// x[XUVCfbNX
	MObject baseUVIndex = attribute.create(
		"baseUVIndex", "bui", MFnNumericData::kInt, 0, &result);
	MayaStatusCheck(result);
	MayaStatusCheck(attribute.setConnectable(false));
	MayaStatusCheck(attribute.setMax(7));
	MayaStatusCheck(attribute.setMin(0));
	MayaStatusCheck(MPxNode::addAttribute(baseUVIndex));
	MayaStatusCheck(MPxNode::attributeAffects(
		baseUVIndex, MPxHwShaderNode::outColor));
}
//------------------------------------------------------------------------------
// eNX`Agr[g̒ǉ
void LampMaterialUtility::addGlossTextureAttribute(){
	MStatus result;
	MFnNumericAttribute attribute;
	// eNX`
	MObject glossTexture = attribute.createColor(
		"glossTexture", "glt", &result);
	MayaStatusCheck(result);
	MayaStatusCheck(attribute.setDefault(1.f, 1.f, 1.f));
	MayaStatusCheck(MPxNode::addAttribute(glossTexture));
	MayaStatusCheck(MPxNode::attributeAffects(
		glossTexture, MPxHwShaderNode::outColor));
	// UVCfbNX
	MObject glossUVIndex = attribute.create(
		"glossUVIndex", "gui", MFnNumericData::kInt, 0, &result);
	MayaStatusCheck(result);
	MayaStatusCheck(attribute.setConnectable(false));
	MayaStatusCheck(attribute.setMax(7));
	MayaStatusCheck(attribute.setMin(0));
	MayaStatusCheck(MPxNode::addAttribute(glossUVIndex));
	MayaStatusCheck(MPxNode::attributeAffects(
		glossUVIndex, MPxHwShaderNode::outColor));
}
//------------------------------------------------------------------------------
// CgeNX`Agr[g̒ǉ
void LampMaterialUtility::addLightTextureAttribute(){
	MStatus result;
	MFnNumericAttribute attribute;
	// CgeNX`
	MObject lightTexture = attribute.createColor(
		"lightTexture", "lgt", &result);
	MayaStatusCheck(result);
	MayaStatusCheck(attribute.setDefault(1.f, 1.f, 1.f));
	MayaStatusCheck(MPxNode::addAttribute(lightTexture));
	MayaStatusCheck(MPxNode::attributeAffects(
		lightTexture, MPxHwShaderNode::outColor));
	// CgUVCfbNX
	MObject lightUVIndex = attribute.create(
		"lightUVIndex", "lui", MFnNumericData::kInt, 0, &result);
	MayaStatusCheck(result);
	MayaStatusCheck(attribute.setConnectable(false));
	MayaStatusCheck(attribute.setMax(7));
	MayaStatusCheck(attribute.setMin(0));
	MayaStatusCheck(MPxNode::addAttribute(lightUVIndex));
	MayaStatusCheck(MPxNode::attributeAffects(
		lightUVIndex, MPxHwShaderNode::outColor));
}
//------------------------------------------------------------------------------
// eNX`Agr[g̒ǉ
void LampMaterialUtility::addStainTextureAttribute(){
	MStatus result;
	MFnNumericAttribute attribute;
	// eNX`
	MObject stainTexture = attribute.createColor(
		"stainTexture", "stt", &result);
	MayaStatusCheck(result);
	MayaStatusCheck(attribute.setDefault(1.f, 1.f, 1.f));
	MayaStatusCheck(MPxNode::addAttribute(stainTexture));
	MayaStatusCheck(MPxNode::attributeAffects(
		stainTexture, MPxHwShaderNode::outColor));
	// UVCfbNX
	MObject stainUVIndex = attribute.create(
		"stainUVIndex", "sui", MFnNumericData::kInt, 0, &result);
	MayaStatusCheck(result);
	MayaStatusCheck(attribute.setConnectable(false));
	MayaStatusCheck(attribute.setMax(7));
	MayaStatusCheck(attribute.setMin(0));
	MayaStatusCheck(MPxNode::addAttribute(stainUVIndex));
	MayaStatusCheck(MPxNode::attributeAffects(
		stainUVIndex, MPxHwShaderNode::outColor));
}
//------------------------------------------------------------------------------
// fBt[YAgr[g̒ǉ
void LampMaterialUtility::addDiffuseAttribute(){
	MStatus result;
	MFnNumericAttribute attribute;
	// fBt[YJ[
	MObject diffuseColor = attribute.createColor(
		"diffuseColor", "dc", &result);
	MayaStatusCheck(result);
	MayaStatusCheck(attribute.setDefault(1.f, 1.f, 1.f));
	MayaStatusCheck(attribute.setConnectable(false));
	MayaStatusCheck(MPxNode::addAttribute(diffuseColor));
	MayaStatusCheck(MPxNode::attributeAffects(
		diffuseColor, MPxHwShaderNode::outColor));
}
//------------------------------------------------------------------------------
// XyLAgr[g̒ǉ
void LampMaterialUtility::addSpecularAttribute(){
	MStatus result;
	MFnNumericAttribute attribute;
	// XyLJ[
	MObject specularColor = attribute.createColor(
		"specularColor", "sc", &result);
	MayaStatusCheck(result);
	MayaStatusCheck(attribute.setDefault(0.f, 0.f, 0.f));
	MayaStatusCheck(attribute.setConnectable(false));
	MayaStatusCheck(MPxNode::addAttribute(specularColor));
	MayaStatusCheck(MPxNode::attributeAffects(
		specularColor, MPxHwShaderNode::outColor));
	// XyLp[
	MObject specularPower = attribute.create(
		"specularPower", "sp", MFnNumericData::kFloat, 8.f, &result);
	MayaStatusCheck(result);
	MayaStatusCheck(attribute.setConnectable(false));
	MayaStatusCheck(attribute.setMax(128.f));
	MayaStatusCheck(attribute.setMin(0.f));
	MayaStatusCheck(MPxNode::addAttribute(specularPower));
	MayaStatusCheck(MPxNode::attributeAffects(
		specularPower, MPxHwShaderNode::outColor));
}
//------------------------------------------------------------------------------
// ArGgAgr[g̒ǉ
void LampMaterialUtility::addAmbientAttribute(){
	MStatus result;
	// ArGgJ[
	MFnNumericAttribute attribute;
	MObject ambientColor = attribute.createColor(
		"ambientColor", "ac", &result);
	MayaStatusCheck(result);
	MayaStatusCheck(attribute.setDefault(1.f, 1.f, 1.f));
	MayaStatusCheck(attribute.setConnectable(false));
	MayaStatusCheck(MPxNode::addAttribute(ambientColor));
	MayaStatusCheck(MPxNode::attributeAffects(
		ambientColor, MPxHwShaderNode::outColor));
}
//------------------------------------------------------------------------------
// G~bVuAgr[g̒ǉ
void LampMaterialUtility::addEmissiveAttribute(){
	MStatus result;
	// G~bVuJ[
	MFnNumericAttribute attribute;
	MObject emissiveColor = attribute.createColor(
		"emissiveColor", "ec", &result);
	MayaStatusCheck(result);
	MayaStatusCheck(attribute.setDefault(0.f, 0.f, 0.f));
	MayaStatusCheck(attribute.setConnectable(false));
	MayaStatusCheck(MPxNode::addAttribute(emissiveColor));
	MayaStatusCheck(MPxNode::attributeAffects(
		emissiveColor, MPxHwShaderNode::outColor));
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
