//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Lamp}eAwb_
 * @author Junpee
 */

#ifndef LAMP_MATERIAL_H_
#define LAMP_MATERIAL_H_

namespace LampForMaya{

//------------------------------------------------------------------------------
/**
 * Lamp}eA
 */
class LampMaterial : public MPxHwShaderNode{
public:
	//--------------------------------------------------------------------------
	// An
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	LampMaterial();

	/**
	 * fXgN^
	 */
	~LampMaterial();

	/**
	 * }eA
	 */
	static void materialInitialize();

	//--------------------------------------------------------------------------
	// `
	//--------------------------------------------------------------------------
	/**
	 * }eÃZbgAbv
	 */
	void materialSetup();

	/**
	 * [UC^[tF[XVF[_
	 * @param plug vO
	 * @param dataBlock f[^ubN
	 */
	MStatus uiShader(const MPlug& plug, MDataBlock& dataBlock);

	//--------------------------------------------------------------------------
	// Agr[gANZT
	//--------------------------------------------------------------------------
	/**
	 * uh[h̎擾
	 * @return uh[h
	 */
	virtual int getBlendMode() const;

	/**
	 * uhL
	 * @return uhLȂtrue
	 */
	virtual bool isBlendEnabled() const{
		return (getBlendMode() != 0);
	}

	/**
	 * At@̎擾
	 * @return At@
	 */
	virtual float getAlpha() const;

	/**
	 * uh\[X̎擾
	 * @return uh\[X
	 */
	virtual int getBlendSource() const;

	/**
	 * uhfXeBl[V̎擾
	 * @return uhfXeBl[V
	 */
	virtual int getBlendDestination() const;

	/**
	 * [UC^[tF[XJ[̎擾
	 * @return [UC^[tF[XJ[
	 */
	virtual Color3f getUIColor() const;

	/**
	 * Z݂̎擾
	 * @return Z
	 */
	virtual bool useZWrite() const;

	/**
	 * ZeXg̎擾
	 * @return ZeXg
	 */
	virtual bool useZTest() const;

	/**
	 * tHOIvV̎擾
	 * @return tHOIvV
	 */
	virtual int getFogOption() const;

	/**
	 * Cg}XN̎擾
	 * @return Cg}XN
	 */
	virtual u_int getLightMask() const;

	/**
	 * Dx̎擾
	 * @return Dx
	 */
	virtual int getPriority() const;

protected:
	/// At@eXgE
	static const float alphaTestBorder_;

	/// uhe[uTCY
	static const int blendTableSize_ = 11;

	/// uhe[u
	static const u_int blendTable_[blendTableSize_];

private:
	// Rs[RXgN^̉B
	LampMaterial(const LampMaterial& copy);

	// Rs[̉B
	void operator =(const LampMaterial& copy);

};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of LAMP_MATERIAL_H_
//------------------------------------------------------------------------------

