//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Lamp}eA
 * @author Junpee
 */

#include "System/stdafx.h"
#include "Material/System/LampMaterial.h"
#include "Graphics/Material/Material.h"
#include "Texture/MayaTextureManager.h"

namespace LampForMaya{

// At@eXgE
const float LampMaterial::alphaTestBorder_ = (4.f / 255.f);

/// uhe[u
const u_int LampMaterial::blendTable_[blendTableSize_] = {
	GL_ZERO,
	GL_ONE,
	GL_SRC_COLOR,
	GL_ONE_MINUS_SRC_COLOR,
	GL_SRC_ALPHA,
	GL_ONE_MINUS_SRC_ALPHA,
	GL_SRC_ALPHA_SATURATE,
	GL_DST_COLOR,
	GL_ONE_MINUS_DST_COLOR,
	GL_DST_ALPHA,
	GL_ONE_MINUS_DST_ALPHA,
};

//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// RXgN^
LampMaterial::LampMaterial(){
	MayaTextureManager::addReference();
}
//------------------------------------------------------------------------------
// fXgN^
LampMaterial::~LampMaterial(){
	MayaTextureManager::removeReference();
}
//------------------------------------------------------------------------------
// }eA
void LampMaterial::materialInitialize(){
	const MObject& outColor = MPxHwShaderNode::outColor;
	MStatus result;
	MFnNumericAttribute attribute;
	// uh[hAgr[g̍쐬
	MObject blendMode = attribute.create(
		"blendMode", "bm", MFnNumericData::kInt, 0, &result);
	MayaStatusCheck(result);
	MayaStatusCheck(attribute.setConnectable(false));
	MayaStatusCheck(attribute.setMax(5));
	MayaStatusCheck(attribute.setMin(0));
	MayaStatusCheck(MPxNode::addAttribute(blendMode));
	MayaStatusCheck(MPxNode::attributeAffects(blendMode, outColor));

	// At@Agr[g̍쐬
	MObject alpha = attribute.create(
		"alpha", "a", MFnNumericData::kFloat, 1.f, &result);
	MayaStatusCheck(result);
	MayaStatusCheck(attribute.setConnectable(false));
	MayaStatusCheck(attribute.setMax(1.f));
	MayaStatusCheck(attribute.setMin(0.f));
	MayaStatusCheck(MPxNode::addAttribute(alpha));
	MayaStatusCheck(MPxNode::attributeAffects(alpha, outColor));

	// uh\[XAgr[g̍쐬
	MObject blendSource = attribute.create(
		"blendSource", "bs", MFnNumericData::kInt, 4, &result);
	MayaStatusCheck(result);
	MayaStatusCheck(attribute.setConnectable(false));
	MayaStatusCheck(attribute.setMax(blendTableSize_ - 1));
	MayaStatusCheck(attribute.setMin(0));
	MayaStatusCheck(MPxNode::addAttribute(blendSource));
	MayaStatusCheck(MPxNode::attributeAffects(blendSource, outColor));

	// uhfXeBl[VAgr[g̍쐬
	MObject blendDestination = attribute.create(
		"blendDestination", "bd", MFnNumericData::kInt, 5, &result);
	MayaStatusCheck(result);
	MayaStatusCheck(attribute.setConnectable(false));
	MayaStatusCheck(attribute.setMax(blendTableSize_ - 1));
	MayaStatusCheck(attribute.setMin(0));
	MayaStatusCheck(MPxNode::addAttribute(blendDestination));
	MayaStatusCheck(MPxNode::attributeAffects(blendDestination, outColor));

	// [UC^[tF[XJ[̍쐬
	MObject uiColor = attribute.createColor("uiColor", "uic", &result);
	MayaStatusCheck(result);
	MayaStatusCheck(attribute.setDefault(1.f, 1.f, 1.f));
	MayaStatusCheck(attribute.setConnectable(false));
	MayaStatusCheck(MPxNode::addAttribute(uiColor));
	MayaStatusCheck(MPxNode::attributeAffects(uiColor, outColor));

	// Z݃Agr[g̍쐬
	MObject zWrite = attribute.create(
		"zWrite", "zwt", MFnNumericData::kBoolean, 1, &result);
	MayaStatusCheck(result);
	MayaStatusCheck(attribute.setConnectable(false));
	MayaStatusCheck(MPxNode::addAttribute(zWrite));
	MayaStatusCheck(MPxNode::attributeAffects(zWrite, outColor));

	// ZeXgAgr[g̍쐬
	MObject zTest = attribute.create(
		"zTest", "zte", MFnNumericData::kBoolean, 1, &result);
	MayaStatusCheck(result);
	MayaStatusCheck(attribute.setConnectable(false));
	MayaStatusCheck(MPxNode::addAttribute(zTest));
	MayaStatusCheck(MPxNode::attributeAffects(zTest, outColor));

	// tHOIvVAgr[g̍쐬
	MObject fogOption = attribute.create(
		"fogOption", "fgo", MFnNumericData::kInt, 0, &result);
	MayaStatusCheck(result);
	MayaStatusCheck(attribute.setConnectable(false));
	MayaStatusCheck(attribute.setMax(2));
	MayaStatusCheck(attribute.setMin(0));
	MayaStatusCheck(MPxNode::addAttribute(fogOption));
	MayaStatusCheck(MPxNode::attributeAffects(fogOption, outColor));

	// Cg}XNAgr[g̍쐬
	MObject lightMask = attribute.create(
		"lightMask", "lgm", MFnNumericData::kInt, 1, &result);
	MayaStatusCheck(result);
	MayaStatusCheck(attribute.setConnectable(false));
	MayaStatusCheck(attribute.setMax(65535));
	MayaStatusCheck(attribute.setMin(0));
	MayaStatusCheck(MPxNode::addAttribute(lightMask));
	MayaStatusCheck(MPxNode::attributeAffects(lightMask, outColor));

	// DxAgr[g̍쐬
	MObject priority = attribute.create(
		"priority", "pri", MFnNumericData::kInt, 0, &result);
	MayaStatusCheck(result);
	MayaStatusCheck(attribute.setConnectable(false));
	MayaStatusCheck(attribute.setMax(Limit::shortMax));
	MayaStatusCheck(attribute.setMin(Limit::shortMin));
	MayaStatusCheck(MPxNode::addAttribute(priority));
	MayaStatusCheck(MPxNode::attributeAffects(priority, outColor));

	// xAgr[g̉B
	MFnNumericAttribute outTransparencyAttribute(
		MPxHwShaderNode::outTransparency, &result);
	MayaStatusCheck(result);
	MayaStatusCheck(outTransparencyAttribute.setWritable(false));
	MayaStatusCheck(outTransparencyAttribute.setStorable(false));

	// }bg`lAgr[g̉B
	MFnNumericAttribute outMatteOpacityAttribute(
		MPxHwShaderNode::outMatteOpacity, &result);
	MayaStatusCheck(result);
	MayaStatusCheck(outMatteOpacityAttribute.setWritable(false));
	MayaStatusCheck(outMatteOpacityAttribute.setStorable(false));

	// OEJ[Agr[g̉B
	MFnNumericAttribute outGlowColorAttribute(
		MPxHwShaderNode::outGlowColor, &result);
	MayaStatusCheck(result);
	MayaStatusCheck(outGlowColorAttribute.setWritable(false));
	MayaStatusCheck(outGlowColorAttribute.setStorable(false));
}
//------------------------------------------------------------------------------
// `
//------------------------------------------------------------------------------
// }eÃZbgAbv
void LampMaterial::materialSetup(){
	// CeBOLɂ
	glEnable(GL_LIGHTING);

	// At@eXgs
	glEnable(GL_ALPHA_TEST);
	glAlphaFunc(GL_GEQUAL, alphaTestBorder_);

	// At@uh
	if(getBlendMode() != 0){
		// glBlendEquation()Ń[hݒł
		glEnable(GL_BLEND);
		// OpenGLłblendDestinationSrcAlphaSaturatew肷ƃG[ɂȂ
		u_int destination = blendTable_[getBlendDestination()];
		if(destination == GL_SRC_ALPHA_SATURATE){ destination = GL_ZERO; }
		glBlendFunc(blendTable_[getBlendSource()], destination);
	}else{
		glDisable(GL_BLEND);
	}

	// Z
	glDepthMask(useZWrite());

	// ZeXg
	if(useZTest()){
		glEnable(GL_DEPTH_TEST);
	}else{
		glDisable(GL_DEPTH_TEST);
	}

	// tHOLǂ
	MStatus result;
	int fogEnabled;
	result = MGlobal::executeCommand(MString(
		"modelEditor -q -fogging modelPanel4;"), fogEnabled, false, false);
	MayaStatusCheck(result);
	if(fogEnabled != 0){
		int fogOption = getFogOption();
		if(fogOption == 1){
			// tHO𖳌ɂ
			glDisable(GL_FOG);
		}else if(fogOption == 2){
			// tHOFɂ
			glFogfv(GL_FOG_COLOR, Color4f::black.array);
		}
	}
	MayaOpenGLCheck();
}
//------------------------------------------------------------------------------
// [UC^[tF[XVF[_
MStatus LampMaterial::uiShader(const MPlug& plug, MDataBlock& dataBlock){
	MStatus result;
	const MObject& outColor = MPxHwShaderNode::outColor;
	if((plug != outColor) && (plug.parent() != outColor)){
		return MS::kUnknownParameter;
	}
	// o̓AhX̎擾
	MDataHandle outColorHandle = dataBlock.outputValue(outColor, &result);
	MayaStatusCheck(result);
	MFloatVector& outputColor = outColorHandle.asFloatVector();
	// Fo
	Color3f uiColor = getUIColor();
	outputColor.x = uiColor.r;
	outputColor.y = uiColor.g;
	outputColor.z = uiColor.b;
	outColorHandle.setClean();
	return MS::kSuccess;
}
//------------------------------------------------------------------------------
// Agr[gANZT
//------------------------------------------------------------------------------
// uh[h̎擾
int LampMaterial::getBlendMode() const{
	return MayaAttributeUtility::getInt(thisMObject(), "blendMode");
}
//------------------------------------------------------------------------------
// At@̎擾
float LampMaterial::getAlpha() const{
	return MayaAttributeUtility::getFloat(thisMObject(), "alpha");
}
//------------------------------------------------------------------------------
// uh\[X̎擾
int LampMaterial::getBlendSource() const{
	return MayaAttributeUtility::getInt(thisMObject(), "blendSource");
}
//------------------------------------------------------------------------------
// uhfXeBl[V̎擾
int LampMaterial::getBlendDestination() const{
	return MayaAttributeUtility::getInt(thisMObject(), "blendDestination");
}
//------------------------------------------------------------------------------
// [UC^[tF[XJ[̎擾
Color3f LampMaterial::getUIColor() const{
	return MayaAttributeUtility::getColor3f(thisMObject(), "uiColor");
}
//------------------------------------------------------------------------------
// Z݂̎擾
bool LampMaterial::useZWrite() const{
	return MayaAttributeUtility::getBool(thisMObject(), "zWrite");
}
//------------------------------------------------------------------------------
// ZeXg̎擾
bool LampMaterial::useZTest() const{
	return MayaAttributeUtility::getBool(thisMObject(), "zTest");
}
//------------------------------------------------------------------------------
// tHOIvV̎擾
int LampMaterial::getFogOption() const{
	return MayaAttributeUtility::getInt(thisMObject(), "fogOption");
}
//------------------------------------------------------------------------------
// Cg}XN̎擾
u_int LampMaterial::getLightMask() const{
	return MayaAttributeUtility::getInt(thisMObject(), "lightMask");
}
//------------------------------------------------------------------------------
// Dx̎擾
int LampMaterial::getPriority() const{
	return MayaAttributeUtility::getInt(thisMObject(), "priority");
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
