//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Lamp{}eAwb_
 * @author Junpee
 */

#ifndef LAMP_BASIC_MATERIAL_H_
#define LAMP_BASIC_MATERIAL_H_

#include <Material/System/LampMaterial.h>

namespace LampForMaya{

//------------------------------------------------------------------------------
/**
 * Lamp{}eA
 */
class LampBasicMaterial : public LampMaterial{
public:
	//--------------------------------------------------------------------------
	// ÓI\bh
	//--------------------------------------------------------------------------
	/**
	 * 
	 *
	 * unloadPluginsȂƃ[NƂČo܂B
	 * @return vOCCX^X
	 */
	static void* creator(){ return new LampBasicMaterial(); }

	/**
	 * 
	 * @return MStatus::kSuccessԂ
	 */
	static MStatus initialize();

	/// ^ID
	static const MTypeId id;

	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	LampBasicMaterial();

	/**
	 * fXgN^
	 */
	virtual ~LampBasicMaterial();

	/**
	 * RXgN^O
	 */
	virtual void postConstructor();

	//--------------------------------------------------------------------------
	// `
	//--------------------------------------------------------------------------
	/**
	 * \tgEFA_O
	 * @param plug vO
	 * @param dataBlock f[^ubN
	 */
	virtual MStatus compute(const MPlug& plug, MDataBlock& dataBlock);

	//--------------------------------------------------------------------------
	/**
	 * xǂ
	 */
	virtual bool hasTransparency();

	/**
	 * _肢̖@KvƂ邩
	 */
	virtual int normalsPerVertex();

	/**
	 * _肢̃J[KvƂ邩
	 */
	virtual int colorsPerVertex();

	/**
	 * _肢UVKvƂ邩
	 */
	virtual int texCoordsPerVertex();

	//--------------------------------------------------------------------------
	/**
	 * `
	 * @return MStatus::kSuccessԂ
	 */
	virtual MStatus glGeometry(
		const MDagPath& shapePath, int prim, u_int writable,
		int indexCount, const u_int* indexArray,
		int vertexCount, const int* vertexIDs, const float* vertexArray,
		int normalCount, const float** normalArrays,
		int colorCount, const float** colorArrays,
		int texCoordCount, const float** texCoordArrays);

	//--------------------------------------------------------------------------
	// Agr[gANZX
	//--------------------------------------------------------------------------
	/**
	 * x[XeNX`̎擾
	 * @return x[XeNX`
	 */
	virtual MObject getBaseTexture() const;

	/**
	 * x[XeNX`̎擾
	 * @return x[XeNX`
	 */
	virtual String getBaseTextureName() const;

	/**
	 * x[XUVCfbNX̎擾
	 * @return x[XUVCfbNX
	 */
	virtual int getBaseUVIndex() const;

	//--------------------------------------------------------------------------
	/**
	 * eNX`̎擾
	 * @return eNX`
	 */
	virtual MObject getGlossTexture() const;

	/**
	 * eNX`̎擾
	 * @return eNX`
	 */
	virtual String getGlossTextureName() const;

	/**
	 * UVCfbNX̎擾
	 * @return UVCfbNX
	 */
	virtual int getGlossUVIndex() const;

	//--------------------------------------------------------------------------
	/**
	 * CgeNX`̎擾
	 * @return CgeNX`
	 */
	virtual MObject getLightTexture() const;

	/**
	 * CgeNX`̎擾
	 * @return CgeNX`
	 */
	virtual String getLightTextureName() const;

	/**
	 * CgUVCfbNX̎擾
	 * @return CgUVCfbNX
	 */
	virtual int getLightUVIndex() const;

	//--------------------------------------------------------------------------
	/**
	 * eNX`̎擾
	 * @return eNX`
	 */
	virtual MObject getStainTexture() const;

	/**
	 * eNX`̎擾
	 * @return eNX`
	 */
	virtual String getStainTextureName() const;

	/**
	 * UVCfbNX̎擾
	 * @return UVCfbNX
	 */
	virtual int getStainUVIndex() const;

	//--------------------------------------------------------------------------
	/**
	 * fBt[YJ[̎擾
	 * @return fBt[YJ[
	 */
	virtual Color3f getDiffuseColor() const;

	//--------------------------------------------------------------------------
	/**
	 * XyLJ[̎擾
	 * @return XyLJ[
	 */
	virtual Color3f getSpecularColor() const;

	/**
	 * XyLp[[̎擾
	 * @return XyLp[
	 */
	virtual float getSpecularPower() const;

	/**
	 * XyLL
	 * @return XyLLȂtrue
	 */
	virtual bool isSpecularEnabled() const{
		return (getSpecularColor() != Color3f::black);
	}

	//--------------------------------------------------------------------------
	/**
	 * ArGgJ[̎擾
	 * @return ArGgJ[
	 */
	virtual Color3f getAmbientColor() const;

	//--------------------------------------------------------------------------
	/**
	 * G~bVuJ[̎擾
	 * @return G~bVuJ[
	 */
	virtual Color3f getEmissiveColor() const;

};

//------------------------------------------------------------------------------
} // End of namespace LampForMaya
#endif // End of LAMP_BASIC_MATERIAL_H_
//------------------------------------------------------------------------------
