//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Lamp{}eA
 * @author Junpee
 */

#include "System/stdafx.h"
#include "System/MayaTypeID.h"
#include "Material/Basic/LampBasicMaterial.h"
#include "Material/Utility/LampMaterialUtility.h"
#include "Texture/MayaTextureManager.h"

namespace LampForMaya{

/// ^ID
const MTypeId LampBasicMaterial::id(MayaTypeID::basicMaterial);

//------------------------------------------------------------------------------
// RXgN^
LampBasicMaterial::LampBasicMaterial(){
}
//------------------------------------------------------------------------------
// fXgN^
LampBasicMaterial::~LampBasicMaterial(){
}
//------------------------------------------------------------------------------
// RXgN^O
void LampBasicMaterial::postConstructor(){
	// }`vZbTΉȂ
	setMPSafe(false);
}
//------------------------------------------------------------------------------
// 
MStatus LampBasicMaterial::initialize(){
	// }eȀ
	LampMaterial::materialInitialize();
	// x[XeNX`Agr[g̍쐬
	LampMaterialUtility::addBaseTextureAttribute();
	// eNX`Agr[g̍쐬
	LampMaterialUtility::addGlossTextureAttribute();
	// CgeNX`Agr[g̍쐬
	LampMaterialUtility::addLightTextureAttribute();
	// eNX`Agr[g̍쐬
	LampMaterialUtility::addStainTextureAttribute();
	// fBt[YAgr[g̍쐬
	LampMaterialUtility::addDiffuseAttribute();
	// XyLAgr[g̍쐬
	LampMaterialUtility::addSpecularAttribute();
	// ArGgAgr[g̍쐬
	LampMaterialUtility::addAmbientAttribute();
	// G~bVuAgr[g̍쐬
	LampMaterialUtility::addEmissiveAttribute();
	return MS::kSuccess;
}
//------------------------------------------------------------------------------
// `
//------------------------------------------------------------------------------
// \tgEFA_O
MStatus LampBasicMaterial::compute(const MPlug& plug, MDataBlock& dataBlock){
	return uiShader(plug, dataBlock);
}
//------------------------------------------------------------------------------
// xǂ
bool LampBasicMaterial::hasTransparency(){ return isBlendEnabled(); }
//------------------------------------------------------------------------------
// _肢̖@KvƂ邩
int LampBasicMaterial::normalsPerVertex(){ return 1; }
//------------------------------------------------------------------------------
// _肢̃J[KvƂ邩
int LampBasicMaterial::colorsPerVertex(){ return 0; }
//------------------------------------------------------------------------------
// _肢UVKvƂ邩
int LampBasicMaterial::texCoordsPerVertex(){
	int maxTexCoord = 0;
	if(getBaseUVIndex() > maxTexCoord){ maxTexCoord = getBaseUVIndex(); }
//	if(getGlossUVIndex() > maxTexCoord){ maxTexCoord = getGlossUVIndex(); }
//	if(getLightUVIndex() > maxTexCoord){ maxTexCoord = getLightUVIndex(); }
//	if(getStainUVIndex() > maxTexCoord){ maxTexCoord = getStainUVIndex(); }
	return maxTexCoord + 1;
}
//------------------------------------------------------------------------------
// `
MStatus LampBasicMaterial::glGeometry(
	const MDagPath& shapePath, int prim, u_int writable,
	int indexCount, const u_int* indexArray,
	int vertexCount, const int* vertexIDs, const float* vertexArray,
	int normalCount, const float** normalArrays,
	int colorCount, const float** colorArrays,
	int texCoordCount, const float** texCoordArrays){
	MStatus result;

	// X^bNɃAgr[gޔ
	glPushAttrib(GL_ALL_ATTRIB_BITS);
	glPushClientAttrib(GL_CLIENT_ALL_ATTRIB_BITS);

	// }eÃZbgAbv
	materialSetup();

	// ʒu̐ݒ
	glEnableClientState(GL_VERTEX_ARRAY);
	glVertexPointer(3, GL_FLOAT, 0, vertexArray);

	// @̐ݒ
	if(normalCount > 0){
		glEnableClientState(GL_NORMAL_ARRAY);
		glNormalPointer(GL_FLOAT, 0, normalArrays[0]);
	}else{
		glDisableClientState(GL_NORMAL_ARRAY);
		glNormal3f(0.f, 0.f, 1.f);
	}

	// eNX`
	if(MayaTextureManager::bind(getBaseTexture())){
		// UV̐ݒ
		// UVɑΉꍇgetTexCoordSetNamesƂg? 
		int baseUVIndex = getBaseUVIndex();
		if(texCoordCount > baseUVIndex){
			glEnableClientState(GL_TEXTURE_COORD_ARRAY);
			glTexCoordPointer(2, GL_FLOAT, 0, texCoordArrays[baseUVIndex]);
		}else{
			glDisableClientState(GL_TEXTURE_COORD_ARRAY);
		}
	}

	// fBt[Y
	Color4f diffuse(getDiffuseColor());
	diffuse.a = getAlpha();
	glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, diffuse.array);

	// XyL
	Color4f specular(getSpecularColor());
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, specular.array);
	glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, getSpecularPower());

	// ArGg
	Color4f ambient(getAmbientColor());
	glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, ambient.array);

	// G~bVu
	Color4f emissive(getEmissiveColor());
	if(colorCount > 0){
		// _J[G~bVƂĈ
		glEnableClientState(GL_COLOR_ARRAY);
		glColorMaterial(GL_FRONT_AND_BACK, GL_EMISSION);
		glEnable(GL_COLOR_MATERIAL);
		if(writable & kWriteColorArrays){
			float* colors = (float*)colorArrays[0];
			for(int i = 0; i < vertexCount; i++){
				colors[0] = colors[0] + emissive.r;
				colors[1] = colors[1] + emissive.g;
				colors[2] = colors[2] + emissive.b;
				colors[3] = colors[3];
				colors += 4;
			}
		}
		glColorPointer(4, GL_FLOAT, 0, colorArrays[0]);
	}else{
		// colorsPerVertex()1ԂꍇAɂ͂Ȃ
		glDisableClientState(GL_COLOR_ARRAY);
		glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION, emissive.array);
	}

	// `
	glDrawElements(prim, indexCount, GL_UNSIGNED_INT, indexArray);

	glPopClientAttrib();
	glPopAttrib();

	MayaStatusCheck(result);
	MayaOpenGLCheck();
	return result;
}
//------------------------------------------------------------------------------
// Agr[gANZT
//------------------------------------------------------------------------------
// x[XeNX`̎擾
MObject LampBasicMaterial::getBaseTexture() const{
	return LampMaterialUtility::getTexture(thisMObject(), "color");
}
//------------------------------------------------------------------------------
// x[XeNX`̎擾
String LampBasicMaterial::getBaseTextureName() const{
	return LampMaterialUtility::getTextureName(thisMObject(), "color");
}
//------------------------------------------------------------------------------
// x[XUVCfbNX̎擾
int LampBasicMaterial::getBaseUVIndex() const{
	return MayaAttributeUtility::getInt(thisMObject(), "baseUVIndex");
}
//------------------------------------------------------------------------------
// eNX`̎擾
MObject LampBasicMaterial::getGlossTexture() const{
	return LampMaterialUtility::getTexture(thisMObject(), "glossTexture");
}
//------------------------------------------------------------------------------
// eNX`̎擾
String LampBasicMaterial::getGlossTextureName() const{
	return LampMaterialUtility::getTextureName(thisMObject(), "glossTexture");
}
//------------------------------------------------------------------------------
// UVCfbNX̎擾
int LampBasicMaterial::getGlossUVIndex() const{
	return MayaAttributeUtility::getInt(thisMObject(), "glossUVIndex");
}
//------------------------------------------------------------------------------
// CgeNX`̎擾
MObject LampBasicMaterial::getLightTexture() const{
	return LampMaterialUtility::getTexture(thisMObject(), "lightTexture");
}
//------------------------------------------------------------------------------
// CgeNX`̎擾
String LampBasicMaterial::getLightTextureName() const{
	return LampMaterialUtility::getTextureName(thisMObject(), "lightTexture");
}
//------------------------------------------------------------------------------
// CgUVCfbNX̎擾
int LampBasicMaterial::getLightUVIndex() const{
	return MayaAttributeUtility::getInt(thisMObject(), "lightUVIndex");
}
//------------------------------------------------------------------------------
// eNX`̎擾
MObject LampBasicMaterial::getStainTexture() const{
	return LampMaterialUtility::getTexture(thisMObject(), "stainTexture");
}
//------------------------------------------------------------------------------
// eNX`̎擾
String LampBasicMaterial::getStainTextureName() const{
	return LampMaterialUtility::getTextureName(thisMObject(), "stainTexture");
}
//------------------------------------------------------------------------------
// UVCfbNX̎擾
int LampBasicMaterial::getStainUVIndex() const{
	return MayaAttributeUtility::getInt(thisMObject(), "stainUVIndex");
}
//------------------------------------------------------------------------------
// fBt[YJ[̎擾
Color3f LampBasicMaterial::getDiffuseColor() const{
	return MayaAttributeUtility::getColor3f(thisMObject(), "diffuseColor");
}
//------------------------------------------------------------------------------
// XyLJ[̎擾
Color3f LampBasicMaterial::getSpecularColor() const{
	return MayaAttributeUtility::getColor3f(thisMObject(), "specularColor");
}
//------------------------------------------------------------------------------
// XyLp[[̎擾
float LampBasicMaterial::getSpecularPower() const{
	return MayaAttributeUtility::getFloat(thisMObject(), "specularPower");
}
//------------------------------------------------------------------------------
// ArGgJ[̎擾
Color3f LampBasicMaterial::getAmbientColor() const{
	return MayaAttributeUtility::getColor3f(thisMObject(), "ambientColor");
}
//------------------------------------------------------------------------------
// G~bVuJ[̎擾
Color3f LampBasicMaterial::getEmissiveColor() const{
	return MayaAttributeUtility::getColor3f(thisMObject(), "emissiveColor");
}
//------------------------------------------------------------------------------
} // End of namespace LampForMaya
//------------------------------------------------------------------------------
