//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eNX`}l[W̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/Texture/TextureManagerTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Texture/TextureManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* TextureManagerTest::suite(){
	TestSuite* suite = new TestSuite("TextureManagerTest");
	suite->addTest(new TestCaller(TextureManagerTest, testConstructor));
	suite->addTest(new TestCaller(TextureManagerTest, testDatabase));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void TextureManagerTest::testConstructor(){
	TestEquals(40, (int)sizeof(TextureManager));
	Scene* scene = LampGraphics::createScene("test");
	TestAssert(scene != NULL);
	TextureManager* manager = scene->getTextureManager();
	TestAssert(manager != NULL);
	// NA
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// f[^x[XeXg
void TextureManagerTest::testDatabase(){
	Scene* scene = LampGraphics::createScene("test");
	TextureManager* manager = scene->getTextureManager();
	// f[^x[X̍\z
	int textureCount = 257;
	String* names = new String[textureCount];
	Texture** textures = new Texture*[textureCount];
	for(int i = 0; i < textureCount; i++){
		names[i].format("texture%d", i);
	}
	for(int i = 0; i < textureCount; i++){
		textures[i] = manager->createSurfaceTexture(names[i]);
	}
	// zANZX
	TestEquals(textureCount, manager->getCount());
	for(int i = 0; i < textureCount; i++){
		TestEquals(names[i], manager->get(i)->getName());
		TestAssert(textures[i] == manager->get(i));
	}
	// ANZX
	for(int i = 0; i < textureCount; i++){
		Texture* texture = manager->search(names[i]);
		TestAssert(texture == manager->get(i));
	}
	// j
	int destroyCount = 64;
	for(int i = 0; i < destroyCount; i++){
		TestEquals(0, manager->destroy(textures[i]));
	}
	// NA
	TestEquals(textureCount - destroyCount, scene->clear());
	TestEquals(0, scene->clear());
	delete[] textures;
	delete[] names;
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
