//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * T[tF[XeNX`̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/Texture/SurfaceTextureTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Texture/TextureManager.h"
#include "Graphics/Material/MaterialManager.h"
#include "Graphics/Picture/PictureManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* SurfaceTextureTest::suite(){
	TestSuite* suite = new TestSuite("SurfaceTextureTest");
	suite->addTest(new TestCaller(SurfaceTextureTest, testData));
	suite->addTest(new TestCaller(SurfaceTextureTest, testReference));
	suite->addTest(new TestCaller(SurfaceTextureTest, testCopy));
	return suite;
}
//------------------------------------------------------------------------------
// f[^eXg
void SurfaceTextureTest::testData(){
//	TestEquals(60, (int)sizeof(SurfaceTexture));
	Scene* scene = LampGraphics::createScene("test");
	TextureManager* manager = scene->getTextureManager();
	SurfaceTexture* tex0 = manager->createSurfaceTexture("tex0");
	TestAssert(tex0->isTexture());
	TestAssert(tex0->isSurfaceTexture());
	// O
	TestEquals("tex0", tex0->getName());
	// AhX[hU
	TestAssert(tex0->getAddressModeU() == Texture::addressModeClamp);
	tex0->setAddressModeU(Texture::addressModeMirror);
	TestAssert(tex0->getAddressModeU() == Texture::addressModeMirror);
	// AhX[hV
	TestAssert(tex0->getAddressModeV() == Texture::addressModeClamp);
	tex0->setAddressModeV(Texture::addressModeMirror);
	TestAssert(tex0->getAddressModeV() == Texture::addressModeMirror);
	// s[gUV
	TestAssert(TexCoord2(1.f, 1.f) == tex0->getRepeatUV());
	tex0->setRepeatUV(TexCoord2(1.2f, 3.4f));
	TestAssert(TexCoord2(1.2f, 3.4f) == tex0->getRepeatUV());
	// ItZbgUV
	TestAssert(TexCoord2(0.f, 0.f) == tex0->getOffsetUV());
	tex0->setOffsetUV(TexCoord2(5.6f, 7.8f));
	TestAssert(TexCoord2(5.6f, 7.8f) == tex0->getOffsetUV());
	// n
	manager->destroy(tex0);
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// QƃeXg
void SurfaceTextureTest::testReference(){
	Scene* scene = LampGraphics::createScene("test");
	TextureManager* manager = scene->getTextureManager();
	SurfaceTexture* tex0 = manager->createSurfaceTexture("tex0");

	// ڂ̃}eA֒ǉ
	TestEquals(0, tex0->getParentCount());
	MaterialManager* materialManager = scene->getMaterialManager();
	BasicMaterial* material0 =
		materialManager->createBasicMaterial("material0");
	TestAssert(material0->getBaseTexture() == NULL);
	material0->setBaseTexture(tex0);
	TestAssert(material0->getBaseTexture() == tex0);
	TestEquals(1, tex0->getParentCount());
	// ڂ̃}eA֒ǉ
	BasicMaterial* material1 =
		materialManager->createBasicMaterial("material1");
	material1->setBaseTexture(tex0);
	TestEquals(2, tex0->getParentCount());
	TestAssert(tex0->getParent(0) == material0);
	TestAssert(tex0->getParent(1) == material1);
	TestEquals(2, manager->destroy(tex0));
	// ڂ̃}eA폜
	material0->removeBaseTexture();
	TestAssert(material0->getBaseTexture() == NULL);
	TestEquals(1, tex0->getParentCount());
	TestEquals(1, manager->destroy(tex0));
	// ڂ̃}eA폜
	material1->setBaseTexture(NULL);
	TestAssert(material1->getBaseTexture() == NULL);
	TestEquals(0, tex0->getParentCount());
	materialManager->destroy(material0);
	materialManager->destroy(material1);

	// n
	TestEquals(0, manager->destroy(tex0));
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// Rs[eXg
void SurfaceTextureTest::testCopy(){
	Scene* scene = LampGraphics::createScene("test");
	TextureManager* manager = scene->getTextureManager();
	SurfaceTexture* tex0 = manager->createSurfaceTexture("tex0");
	tex0->setAddressModeU(Texture::addressModeMirror);
	tex0->setAddressModeV(Texture::addressModeMirror);
	tex0->setRepeatUV(TexCoord2(1.2f, 3.4f));
	tex0->setOffsetUV(TexCoord2(5.6f, 7.8f));
	PictureManager* pictureManager = scene->getPictureManager();
	Picture* pic0 = pictureManager->createPictureRGB8("pic0");
	tex0->addPicture(pic0);
	// Rs[
	SurfaceTexture* tex1 = tex0->copySurfaceTexture(0);
	TestEquals("tex0_0", tex1->getName());
	TestAssert(tex1->getAddressModeU() == Texture::addressModeMirror);
	TestAssert(tex1->getAddressModeV() == Texture::addressModeMirror);
	TestAssert(TexCoord2(1.2f, 3.4f) == tex1->getRepeatUV());
	TestAssert(TexCoord2(5.6f, 7.8f) == tex1->getOffsetUV());
	TestAssert(tex1->getPictureCount() == 1);
	TestAssert(tex1->getPicture(0) == pic0);
	// n
	TestEquals(1, Texture::recursiveDestroy(tex0));
	TestEquals(2, Texture::recursiveDestroy(tex1));
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
